
<?php $__env->startSection('content'); ?>
<h1>Ürün Yönetimi</h1>
<div class="mt">
    <a class="btn" href="<?php echo e(route('admin.products.create')); ?>">Yeni Ürün Ekle</a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success mt"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<div class="mt" style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;">
    <table>
        <thead>
            <tr>
                <th>Görsel</th>
                <th>Ürün Adı</th>
                <th>Kategori</th>
                <th>Fiyat</th>
                <th>İndirimli Fiyat</th>
                <th>Stok</th>
                <th>Durum</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <?php if($product->image): ?>
                            <img src="<?php echo e(asset($product->image)); ?>" alt="<?php echo e($product->name); ?>" style="width:60px;height:60px;object-fit:cover;border-radius:4px;">
                        <?php else: ?>
                            <div style="width:60px;height:60px;background:#e5e7eb;border-radius:4px;display:flex;align-items:center;justify-content:center;color:#9ca3af;">Görsel Yok</div>
                        <?php endif; ?>
                    </td>
                    <td>
                        <strong><?php echo e($product->name); ?></strong>
                        <div style="font-size:12px;color:#6b7280;margin-top:4px;">
                            <?php if($product->is_organic): ?>
                                <span style="color:#10b981;">🌿 Organik</span> |
                            <?php endif; ?>
                            <?php if($product->is_featured): ?>
                                <span style="color:#f59e0b;">⭐ Öne Çıkan</span> |
                            <?php endif; ?>
                            SKU: <?php echo e($product->sku ?? 'Yok'); ?>

                        </div>
                    </td>
                    <td><?php echo e($product->category->name ?? 'Kategori Yok'); ?></td>
                    <td>
                        <strong><?php echo e(number_format($product->price, 2, ',', '.')); ?> TL</strong>
                        <?php if($product->sale_price): ?>
                            <div style="text-decoration:line-through;color:#9ca3af;font-size:12px;">
                                <?php echo e(number_format($product->sale_price, 2, ',', '.')); ?> TL
                            </div>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($product->sale_price): ?>
                            <strong style="color:#10b981;"><?php echo e(number_format($product->sale_price, 2, ',', '.')); ?> TL</strong>
                            <?php if($product->price > $product->sale_price): ?>
                                <div style="color:#ef4444;font-size:12px;">
                                    %<?php echo e(round((($product->price - $product->sale_price) / $product->price) * 100)); ?> İndirim
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <span style="color:#9ca3af;">-</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($product->in_stock): ?>
                            <span style="color:#10b981;">✓ Stokta</span>
                            <div style="font-size:12px;color:#6b7280;"><?php echo e($product->stock_quantity); ?> adet</div>
                        <?php else: ?>
                            <span style="color:#ef4444;">✗ Stokta Yok</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($product->is_active): ?>
                            <span class="badge" style="background:#d1fae5;color:#065f46;">Aktif</span>
                        <?php else: ?>
                            <span class="badge" style="background:#fee2e2;color:#991b1b;">Pasif</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="flex">
                            <a class="btn btn-sm" href="<?php echo e(route('admin.products.edit', $product)); ?>" style="font-size:12px;padding:6px 12px;">Düzenle</a>
                            <form action="<?php echo e(route('admin.products.destroy', $product)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Bu ürünü silmek istediğinize emin misiniz?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" style="font-size:12px;padding:6px 12px;">Sil</button>
                            </form>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" style="text-align:center;padding:40px;color:#6b7280;">
                        Henüz ürün bulunmuyor. İlk ürünü oluşturun.
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <?php if($products->hasPages()): ?>
        <div class="mt" style="display:flex;justify-content:center;">
            <?php echo e($products->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/products/index.blade.php ENDPATH**/ ?>