
<?php $__env->startSection('content'); ?>
<h1>Sayfa Düzenle</h1>

<form method="POST" action="<?php echo e(route('admin.pages.update', $page)); ?>" class="mt">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    
    <div class="form-group">
        <label>Slug (URL)</label>
        <input type="text" name="slug" value="<?php echo e(old('slug', $page->slug)); ?>" required class="form-control" placeholder="ornek-sayfa">
        <small>URL'de görünecek kısım (örn: ornek-sayfa)</small>
    </div>

    <div class="form-group">
        <label>Başlık</label>
        <input type="text" name="title" value="<?php echo e(old('title', $page->title)); ?>" required class="form-control">
    </div>

    <div class="form-group">
        <label>İçerik</label>
        <textarea name="content" rows="10" class="form-control"><?php echo e(old('content', $page->content)); ?></textarea>
    </div>

    <hr style="margin:30px 0;border:none;border-top:1px solid #e5e7eb;">

    <h2 style="margin-bottom:20px;">SEO Ayarları</h2>

    <div class="form-group">
        <label>Meta Başlık (Title)</label>
        <input type="text" name="meta_title" value="<?php echo e(old('meta_title', $page->meta_title)); ?>" class="form-control" maxlength="60">
        <small>Maksimum 60 karakter önerilir. Boş bırakılırsa sayfa başlığı kullanılır.</small>
    </div>

    <div class="form-group">
        <label>Meta Açıklama (Description)</label>
        <textarea name="meta_description" rows="3" class="form-control" maxlength="160"><?php echo e(old('meta_description', $page->meta_description)); ?></textarea>
        <small>Maksimum 160 karakter önerilir</small>
    </div>

    <div class="form-group">
        <label>Meta Anahtar Kelimeleri</label>
        <input type="text" name="meta_keywords" value="<?php echo e(old('meta_keywords', $page->meta_keywords)); ?>" class="form-control" placeholder="kelime1, kelime2, kelime3">
        <small>Virgülle ayrılmış anahtar kelimeler</small>
    </div>

    <div class="form-group">
        <label>
            <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $page->is_active) ? 'checked' : ''); ?>>
            Aktif
        </label>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Güncelle</button>
        <a class="btn secondary" href="<?php echo e(route('admin.pages.index')); ?>">İptal</a>
    </div>
</form>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/pages/edit.blade.php ENDPATH**/ ?>