
<?php $__env->startSection('content'); ?>
<h1>Kategori Düzenle: <?php echo e($category->name); ?></h1>

<form method="POST" action="<?php echo e(route('admin.categories.update', $category)); ?>" enctype="multipart/form-data" class="mt">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    
    <div class="form-group">
        <label>Kategori Adı *</label>
        <input type="text" name="name" value="<?php echo e(old('name', $category->name)); ?>" required class="form-control" placeholder="Örn: Taze Meyve">
    </div>

    <div class="form-group">
        <label>Ana Kategori</label>
        <select name="parent_id" class="form-control">
            <option value="">Ana Kategori (Üst kategori yok)</option>
            <?php $__currentLoopData = $parentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($parent->id); ?>" <?php echo e(old('parent_id', $category->parent_id) == $parent->id ? 'selected' : ''); ?>>
                    <?php echo e($parent->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <small>Boş bırakılırsa ana kategori olarak kalır</small>
    </div>

    <div class="form-group">
        <label>İkon (Emoji veya Font Awesome class)</label>
        <input type="text" name="icon" value="<?php echo e(old('icon', $category->icon)); ?>" class="form-control" placeholder="🍎 veya fa fa-apple">
    </div>

    <div class="form-group">
        <label>Banner Görsel (500x500 px)</label>
        <input type="file" name="banner_image" accept="image/*" class="form-control">
        <?php if($category->banner_image): ?>
            <div style="margin-top:10px;">
                <img src="<?php echo e($category->banner_image); ?>" alt="Banner" style="max-width:200px;border:1px solid #e5e7eb;border-radius:4px;padding:5px;">
                <p style="margin:5px 0 0 0;font-size:12px;color:#666;">Mevcut banner görseli</p>
            </div>
        <?php endif; ?>
        <small>Yeni görsel yüklerseniz mevcut görsel değiştirilecektir. 500x500 piksel boyutunda olmalıdır.</small>
    </div>

    <div class="form-group">
        <label>Açıklama</label>
        <textarea name="description" rows="4" class="form-control" placeholder="Kategori hakkında kısa açıklama..."><?php echo e(old('description', $category->description)); ?></textarea>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="<?php echo e(old('order', $category->order)); ?>" class="form-control" min="0">
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $category->is_active) ? 'checked' : ''); ?>>
                Aktif
            </label>
        </div>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Güncelle</button>
        <a class="btn secondary" href="<?php echo e(route('admin.categories.index')); ?>">İptal</a>
    </div>
</form>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/categories/edit.blade.php ENDPATH**/ ?>