﻿@extends('layouts.app')
@section('content')
    <style>
        .product-wrapper { max-width: 1200px; margin: 0 auto; padding: 30px 16px; }
        
        /* Breadcrumb */
        .breadcrumb { margin-bottom: 20px; font-size: 14px; color: #666; }
        .breadcrumb a { color: #73ae43; text-decoration: none; }
        .breadcrumb a:hover { text-decoration: underline; }
        .breadcrumb span { margin: 0 8px; color: #999; }
        
        /* Product Container */
        .product-container { display: grid; grid-template-columns: 1fr 1fr; gap: 40px; margin-bottom: 50px; }
        @media (max-width: 768px) {
            .product-container { grid-template-columns: 1fr; gap: 30px; }
        }
        
        /* Product Images */
        .product-images { position: sticky; top: 20px; }
        .product-main-image { width: 100%; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 16px rgba(0,0,0,0.1); margin-bottom: 15px; background: #f9f9f9; }
        .product-main-image img { width: 100%; height: auto; display: block; }
        .product-thumbnails { display: grid; grid-template-columns: repeat(4, 1fr); gap: 10px; }
        .product-thumbnail { border-radius: 8px; overflow: hidden; cursor: pointer; border: 2px solid transparent; transition: all 0.3s; }
        .product-thumbnail:hover, .product-thumbnail.active { border-color: #73ae43; }
        .product-thumbnail img { width: 100%; height: 80px; object-fit: cover; display: block; }
        
        /* Product Info */
        .product-info h1 { font-size: 28px; font-weight: 700; color: #333; margin-bottom: 15px; line-height: 1.3; }
        .product-rating { display: flex; align-items: center; gap: 10px; margin-bottom: 20px; }
        .product-rating .stars { display: flex; gap: 4px; }
        .product-rating .star { font-size: 22px; color: #ddd; transition: all 0.2s; cursor: pointer; }
        .product-rating .star.filled { color: #ffc107; }
        .product-rating .star.half { background: linear-gradient(90deg, #ffc107 50%, #ddd 50%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .product-rating .reviews { color: #666; font-size: 14px; }
        
        /* Star Rating Input */
        .star-rating-input { display: flex; gap: 8px; align-items: center; margin: 20px 0; }
        .star-rating-input .stars { display: flex; gap: 6px; }
        .star-rating-input .star { font-size: 32px; color: #ddd; cursor: pointer; transition: all 0.2s; }
        .star-rating-input .star:hover { color: #ffc107; transform: scale(1.1); }
        .star-rating-input .star.selected { color: #ffc107; }
        .star-rating-input .star.selected ~ .star { color: #ddd; }
        
        /* Reviews Section */
        .reviews-section { margin-top: 50px; padding-top: 30px; border-top: 2px solid #e5e7eb; }
        .reviews-section h3 { font-size: 24px; font-weight: 700; color: #333; margin-bottom: 20px; }
        .review-form { background: #f9fafb; padding: 25px; border-radius: 12px; margin-bottom: 30px; }
        .review-form textarea { width: 100%; padding: 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 14px; resize: vertical; min-height: 100px; }
        .review-form button { background: #ff6b35; color: #fff; padding: 12px 24px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: all 0.3s; margin-top: 15px; }
        .review-form button:hover { background: #e55a2b; }
        .review-item { background: #fff; padding: 20px; border-radius: 8px; margin-bottom: 15px; border: 1px solid #e5e7eb; }
        .review-item-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .review-item-user { font-weight: 600; color: #333; }
        .review-item-date { color: #999; font-size: 12px; }
        .review-item-rating { display: flex; gap: 4px; margin-bottom: 10px; }
        .review-item-comment { color: #666; line-height: 1.6; }
        
        .product-price-section { background: linear-gradient(135deg, #f0f9f4 0%, #d1fae5 100%); padding: 20px; border-radius: 12px; margin-bottom: 25px; }
        .product-price { font-size: 36px; font-weight: 700; color: #73ae43; margin-bottom: 8px; }
        .product-old-price { font-size: 20px; color: #999; text-decoration: line-through; margin-bottom: 8px; }
        .product-discount { display: inline-block; background: #10b981; color: #fff; padding: 6px 12px; border-radius: 6px; font-size: 14px; font-weight: 600; margin-left: 10px; }
        .product-tax { font-size: 14px; color: #666; }
        
        .product-description { margin-bottom: 30px; }
        .product-description h3 { font-size: 18px; font-weight: 600; color: #333; margin-bottom: 12px; }
        .product-description p { color: #666; line-height: 1.8; font-size: 15px; }
        
        .product-features { margin-bottom: 30px; }
        .product-features ul { list-style: none; padding: 0; }
        .product-features li { padding: 10px 0; border-bottom: 1px solid #eee; color: #666; }
        .product-features li:last-child { border-bottom: none; }
        .product-features li strong { color: #333; margin-right: 10px; }
        
        /* Quantity & Actions */
        .product-actions { margin-bottom: 30px; }
        .quantity-selector { display: flex; align-items: center; gap: 15px; margin-bottom: 20px; }
        .quantity-btn { width: 40px; height: 40px; border: 2px solid #ff6b35; background: #fff; color: #ff6b35; border-radius: 8px; font-size: 20px; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.3s; }
        .quantity-btn:hover { background: #ff6b35; color: #fff; }
        .quantity-input { width: 80px; height: 40px; border: 2px solid #ddd; border-radius: 8px; text-align: center; font-size: 18px; font-weight: 600; }
        
        .action-buttons { display: flex; gap: 15px; }
        .btn-primary { flex: 1; background: #ff6b35; color: #fff; padding: 16px 24px; border-radius: 8px; font-size: 16px; font-weight: 600; text-align: center; text-decoration: none; border: none; cursor: pointer; transition: all 0.3s; display: flex; align-items: center; justify-content: center; gap: 8px; }
        .btn-primary:hover { background: #e55a2b; transform: translateY(-2px); box-shadow: 0 6px 16px rgba(255,107,53,0.3); }
        .btn-secondary { width: 50px; height: 50px; background: #fff; border: 2px solid #ff6b35; color: #ff6b35; border-radius: 8px; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: all 0.3s; font-size: 20px; }
        .btn-secondary:hover { background: #ff6b35; color: #fff; }
        
        /* Related Products */
        .related-products { margin-top: 60px; }
        .related-products h2 { font-size: 24px; font-weight: 700; margin-bottom: 25px; color: #333; padding-bottom: 10px; border-bottom: 3px solid #73ae43; }
        .related-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 20px; }
        .related-card { background: #fff; border: 1px solid #eee; border-radius: 8px; padding: 15px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: all 0.3s; }
        .related-card:hover { transform: translateY(-5px); box-shadow: 0 6px 16px rgba(0,0,0,0.12); }
        .related-card img { width: 100%; height: 160px; object-fit: cover; border-radius: 6px; margin-bottom: 12px; }
        .related-card .name { font-weight: 600; font-size: 14px; color: #333; margin-bottom: 8px; }
        .related-card .price { font-weight: 700; color: #73ae43; font-size: 16px; }
        
        /* Product Tabs */
        .product-tabs { margin-top: 50px; }
        .product-tabs-nav { display: flex; gap: 0; border-bottom: 2px solid #e5e7eb; margin-bottom: 30px; }
        .product-tabs-nav button { background: none; border: none; padding: 15px 30px; font-size: 16px; font-weight: 600; color: #666; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.3s; position: relative; top: 2px; }
        .product-tabs-nav button:hover { color: #73ae43; }
        .product-tabs-nav button.active { color: #73ae43; border-bottom-color: #73ae43; }
        .product-tabs-content { display: none; }
        .product-tabs-content.active { display: block; }
        .product-tabs-content h3 { font-size: 20px; font-weight: 700; color: #333; margin-bottom: 15px; }
        .product-tabs-content p { color: #666; line-height: 1.8; font-size: 15px; margin-bottom: 15px; }
        .product-tabs-content ul { list-style: none; padding: 0; }
        .product-tabs-content li { padding: 10px 0; border-bottom: 1px solid #eee; color: #666; }
        .product-tabs-content li:last-child { border-bottom: none; }
        .product-tabs-content li strong { color: #333; margin-right: 10px; }
    </style>

    <div class="product-wrapper">
        <!-- Breadcrumb -->
        <div class="breadcrumb">
            <a href="{{ route('home') }}">Ana Sayfa</a>
            <span>/</span>
            @if($product->category)
                <a href="{{ route('category.show', $product->category->slug) }}">{{ $product->category->name }}</a>
                <span>/</span>
            @endif
            <span>{{ $product->name }}</span>
        </div>

        <!-- Product Container -->
        <div class="product-container">
            <!-- Product Images -->
            <div class="product-images">
                <div class="product-main-image">
                    <img id="mainImage" src="{{ $product->image ? asset($product->image) : asset('images/placeholder.png') }}" alt="{{ $product->name }}">
                </div>
                @php
                    $images = $product->gallery ?? [];
                    if ($product->image) {
                        array_unshift($images, $product->image);
                    }
                @endphp
                @if(count($images) > 1)
                    <div class="product-thumbnails">
                        @foreach ($images as $index => $image)
                            <div class="product-thumbnail {{ $index === 0 ? 'active' : '' }}" onclick="changeImage('{{ asset($image) }}')">
                                <img src="{{ asset($image) }}" alt="{{ $product->name }}">
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            <!-- Product Info -->
            <div class="product-info">
                <h1>{{ $product->name }}</h1>
                
                @if($product->farm_name || $product->origin)
                    <div style="margin-bottom: 15px; color: #666; font-size: 14px;">
                        @if($product->farm_name)
                            <span>{{ $product->farm_name }}</span>
                        @endif
                        @if($product->origin)
                            @if($product->farm_name) - @endif
                            <span>{{ $product->origin }}</span>
                        @endif
                    </div>
                @endif
                
                <div class="product-rating">
                    <div class="stars">
                        @php
                            $avgRating = $product->average_rating ?? $product->rating;
                            $fullStars = floor($avgRating);
                            $hasHalfStar = ($avgRating - $fullStars) >= 0.5;
                        @endphp
                        @for ($i = 0; $i < 5; $i++)
                            @if ($i < $fullStars)
                                <span class="star filled">★</span>
                            @elseif ($i == $fullStars && $hasHalfStar)
                                <span class="star half">★</span>
                            @else
                                <span class="star">☆</span>
                            @endif
                        @endfor
                    </div>
                    <span class="reviews">({{ $product->review_count ?? 0 }} değerlendirme)</span>
                </div>

                <div class="product-price-section">
                    <div class="product-price">
                        @if($product->sale_price)
                            {{ number_format($product->sale_price, 2, ',', '.') }} TL
                            @if($product->price > $product->sale_price)
                                @php
                                    $discount = round((($product->price - $product->sale_price) / $product->price) * 100);
                                @endphp
                                <span class="product-discount">%{{ $discount }} İndirim</span>
                            @endif
                        @else
                            {{ number_format($product->price, 2, ',', '.') }} TL
                        @endif
                    </div>
                    @if($product->sale_price && $product->price > $product->sale_price)
                        <div class="product-old-price">{{ number_format($product->price, 2, ',', '.') }} TL</div>
                    @endif
                    <div class="product-tax">KDV Dahil</div>
                </div>

                <div class="product-features">
                    <h3>Ürün Özellikleri</h3>
                    <ul>
                        @if($product->is_organic)
                            <li><strong>Organik:</strong> Evet</li>
                        @endif
                        @if($product->weight)
                            <li><strong>Ağırlık/Miktar:</strong> {{ $product->weight }}</li>
                        @endif
                        @if($product->origin)
                            <li><strong>Menşei:</strong> {{ $product->origin }}</li>
                        @endif
                        @if($product->farm_name)
                            <li><strong>Çiftlik:</strong> {{ $product->farm_name }}</li>
                        @endif
                        @if($product->brand)
                            <li><strong>Marka:</strong> {{ $product->brand }}</li>
                        @endif
                        <li><strong>Stok Durumu:</strong> {{ $product->in_stock ? 'Stokta Var' : 'Stokta Yok' }}</li>
                        @if($product->stock_quantity > 0)
                            <li><strong>Stok Miktarı:</strong> {{ $product->stock_quantity }} adet</li>
                        @endif
                    </ul>
                </div>

                <div class="product-actions">
                    <div class="quantity-selector">
                        <label style="font-weight: 600; color: #333;">Adet:</label>
                        <button class="quantity-btn" onclick="decreaseQuantity()">-</button>
                        <input type="number" id="quantity" class="quantity-input" value="1" min="1" max="{{ $product->stock_quantity > 0 ? $product->stock_quantity : 99 }}">
                        <button class="quantity-btn" onclick="increaseQuantity()">+</button>
                    </div>
                    
                    <div class="action-buttons">
                        <button class="btn-primary" onclick="addToCart({{ $product->id }})" {{ !$product->in_stock ? 'disabled' : '' }}>
                            <span>🛒</span>
                            <span>{{ $product->in_stock ? 'SEPETE EKLE' : 'STOKTA YOK' }}</span>
                        </button>
                        <button class="btn-secondary" onclick="toggleFavorite({{ $product->id }})" title="Favorilere Ekle">
                            ❤️
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Product Tabs -->
        <div class="product-tabs">
            <div class="product-tabs-nav">
                <button class="active" onclick="showTab('description')">Açıklama</button>
                <button onclick="showTab('delivery')">TESLİMAT</button>
                <button onclick="showTab('certificates')">SERTİFİKALAR</button>
            </div>
            
            <div id="tab-description" class="product-tabs-content active">
                @if($product->description_detail)
                    <div>{!! nl2br(e($product->description_detail)) !!}</div>
                @elseif($product->description)
                    <div>{!! nl2br(e($product->description)) !!}</div>
                @else
                    <p>Bu ürün için henüz detaylı açıklama eklenmemiş.</p>
                @endif
            </div>
            
            <div id="tab-delivery" class="product-tabs-content">
                @if($product->delivery_info)
                    <div>{!! nl2br(e($product->delivery_info)) !!}</div>
                @else
                    <p>Bu ürün için henüz teslimat bilgisi eklenmemiş.</p>
                @endif
            </div>
            
            <div id="tab-certificates" class="product-tabs-content">
                @if($product->certificates_info)
                    <div>{!! nl2br(e($product->certificates_info)) !!}</div>
                @else
                    <p>Bu ürün için henüz sertifika bilgisi eklenmemiş.</p>
                @endif
            </div>
        </div>

        <!-- Reviews Section -->
        <div class="reviews-section">
            <h3>Değerlendirmeler ({{ $product->review_count ?? 0 }})</h3>
            
            @if(isset($canReview) && $canReview && !isset($userReview))
                <div class="review-form">
                    <form action="{{ route('reviews.store', $product->id) }}" method="POST">
                        @csrf
                        <div class="star-rating-input">
                            <label style="font-weight: 600; color: #333;">Puanınız:</label>
                            <div class="stars">
                                @for ($i = 1; $i <= 5; $i++)
                                    <span class="star" onclick="selectRating({{ $i }})" data-rating="{{ $i }}">☆</span>
                                @endfor
                            </div>
                            <input type="hidden" name="rating" id="rating-input" required>
                        </div>
                        <textarea name="comment" placeholder="Yorumunuzu yazın (isteğe bağlı)..." class="form-control"></textarea>
                        @error('rating')
                            <div style="color: #ef4444; font-size: 14px; margin-top: 5px;">{{ $message }}</div>
                        @enderror
                        @error('error')
                            <div style="color: #ef4444; font-size: 14px; margin-top: 5px;">{{ $message }}</div>
                        @enderror
                        @if(session('success'))
                            <div style="color: #10b981; font-size: 14px; margin-top: 5px;">{{ session('success') }}</div>
                        @endif
                        <button type="submit">Yorumu Gönder</button>
                    </form>
                </div>
            @elseif(isset($userReview) && $userReview)
                <div style="background: #f0f9f4; padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #10b981;">
                    ✓ Bu ürüne zaten yorum yaptınız.
                </div>
            @elseif(!auth()->check())
                <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #92400e;">
                    Yorum yapmak için <a href="{{ route('auth.login') }}" style="color: #73ae43; font-weight: 600;">giriş yapın</a> ve bu ürünü satın alın.
                </div>
            @elseif(isset($canReview) && !$canReview)
                <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #92400e;">
                    Bu ürüne yorum yapmak için önce satın alma yapmalısınız.
                </div>
            @endif

            @if(isset($reviews) && $reviews->count() > 0)
                @foreach($reviews as $review)
                    <div class="review-item">
                        <div class="review-item-header">
                            <div class="review-item-user">{{ $review->user->name ?? 'Anonim' }}</div>
                            <div class="review-item-date">{{ $review->created_at->format('d.m.Y') }}</div>
                        </div>
                        <div class="review-item-rating">
                            @for ($i = 0; $i < 5; $i++)
                                @if ($i < $review->rating)
                                    <span class="star filled">★</span>
                                @else
                                    <span class="star">☆</span>
                                @endif
                            @endfor
                        </div>
                        @if($review->comment)
                            <div class="review-item-comment">{{ $review->comment }}</div>
                        @endif
                    </div>
                @endforeach
                
                <div style="margin-top: 20px;">
                    {{ $reviews->links() }}
                </div>
            @else
                <p style="color: #666; text-align: center; padding: 40px;">Henüz değerlendirme yapılmamış.</p>
            @endif
        </div>

        <!-- Related Products -->
        @if(isset($relatedProducts) && $relatedProducts->count() > 0)
            <div class="related-products">
                <h2>Benzer Ürünler</h2>
                <div class="related-grid">
                    @foreach ($relatedProducts as $related)
                        <div class="related-card">
                            <a href="{{ route('product.show', ['slug' => $related->slug]) }}">
                                <img src="{{ $related->image ? asset($related->image) : asset('images/placeholder.png') }}" alt="{{ $related->name }}">
                            </a>
                            <div class="name">{{ $related->name }}</div>
                            <div class="price">
                                @if($related->sale_price)
                                    {{ number_format($related->sale_price, 2, ',', '.') }} TL
                                @else
                                    {{ number_format($related->price, 2, ',', '.') }} TL
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>

    <script>
        function changeImage(imageSrc) {
            document.getElementById('mainImage').src = imageSrc;
            document.querySelectorAll('.product-thumbnail').forEach(thumb => {
                thumb.classList.remove('active');
            });
            event.currentTarget.classList.add('active');
        }

        function increaseQuantity() {
            const input = document.getElementById('quantity');
            const max = parseInt(input.getAttribute('max')) || 99;
            const current = parseInt(input.value) || 1;
            if (current < max) {
                input.value = current + 1;
            }
        }

        function decreaseQuantity() {
            const input = document.getElementById('quantity');
            const current = parseInt(input.value) || 1;
            if (current > 1) {
                input.value = current - 1;
            }
        }

        function addToCart(productId) {
            const quantity = document.getElementById('quantity').value;
            // Backend entegrasyonu için hazır - AJAX çağrısı yapılacak
            alert('Ürün sepete eklendi! (Backend entegrasyonu sonrası aktif olacak)');
        }

        function toggleFavorite(productId) {
            // Backend entegrasyonu için hazır - AJAX çağrısı yapılacak
            alert('Favorilere eklendi! (Backend entegrasyonu sonrası aktif olacak)');
        }

        function showTab(tabName) {
            // Hide all tabs
            document.querySelectorAll('.product-tabs-content').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Remove active class from all buttons
            document.querySelectorAll('.product-tabs-nav button').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Show selected tab
            document.getElementById('tab-' + tabName).classList.add('active');
            
            // Add active class to clicked button
            event.target.classList.add('active');
        }

        function selectRating(rating) {
            document.getElementById('rating-input').value = rating;
            const stars = document.querySelectorAll('.star-rating-input .star');
            stars.forEach((star, index) => {
                if (index < rating) {
                    star.classList.add('selected');
                    star.textContent = '★';
                } else {
                    star.classList.remove('selected');
                    star.textContent = '☆';
                }
            });
        }
    </script>
@endsection
