@extends('member.layout')
@section('member-content')
<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;flex-wrap:wrap;gap:16px;">
    <h1 style="margin:0;color:#414141;font-size:24px;font-weight:600;">İade/Değişim Talebi Oluştur</h1>
    <a href="{{ route('member.orders.show', $order) }}" style="color:#7db64f;text-decoration:none;font-size:14px;font-weight:600;">← Sipariş Detayına Dön</a>
</div>

<div style="background:#f9f9f9;border-radius:8px;padding:20px;margin-bottom:24px;">
    <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Sipariş Bilgisi</h2>
    <div style="color:#666;">
        <div style="font-weight:600;color:#414141;margin-bottom:8px;">Sipariş #{{ $order->order_number }}</div>
        <div>Sipariş Tarihi: {{ $order->created_at->format('d.m.Y H:i') }}</div>
        <div>Toplam Tutar: {{ number_format($order->total, 2) }} ₺</div>
    </div>
</div>

<form method="POST" action="{{ route('member.returns.store', $order) }}" style="max-width:600px;">
    @csrf
    
    <div style="margin-bottom:20px;">
        <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Talep Tipi <span style="color:#e74c3c;">*</span></label>
        <select name="type" required id="return_type" style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
            <option value="return" {{ old('type') == 'return' ? 'selected' : '' }}>İade</option>
            <option value="exchange" {{ old('type') == 'exchange' ? 'selected' : '' }}>Değişim</option>
            <option value="cancellation" {{ old('type') == 'cancellation' ? 'selected' : '' }}>İptal</option>
        </select>
    </div>

    @if($order->items->count() > 1)
    <div style="margin-bottom:20px;">
        <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Ürün Seç (Opsiyonel)</label>
        <select name="order_item_id" style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
            <option value="">Tüm Sipariş</option>
            @foreach($order->items as $item)
                <option value="{{ $item->id }}" {{ old('order_item_id') == $item->id ? 'selected' : '' }}>
                    {{ $item->product_name }} ({{ $item->quantity }} adet)
                </option>
            @endforeach
        </select>
    </div>
    @endif

    <div style="margin-bottom:20px;">
        <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Talep Nedeni <span style="color:#e74c3c;">*</span></label>
        <textarea name="reason" required rows="5" placeholder="Lütfen iade/değişim nedeninizi detaylı olarak açıklayın..." 
                  style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;resize:vertical;">{{ old('reason') }}</textarea>
        <small style="color:#666;font-size:12px;margin-top:4px;display:block;">En az 10 karakter olmalıdır</small>
    </div>

    <div style="display:flex;gap:12px;">
        <button type="submit" style="flex:1;padding:14px 24px;background:#7db64f;color:#fff;border:none;border-radius:4px;font-size:16px;font-weight:600;cursor:pointer;">Talep Oluştur</button>
        <a href="{{ route('member.orders.show', $order) }}" style="flex:1;padding:14px 24px;background:#f0f0f0;color:#414141;text-decoration:none;border-radius:4px;font-size:16px;font-weight:600;text-align:center;">İptal</a>
    </div>
</form>
@endsection

