@extends('member.layout')
@section('member-content')
<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;flex-wrap:wrap;gap:16px;">
    <h1 style="margin:0;color:#414141;font-size:24px;font-weight:600;">Sipariş Detayı #{{ $order->order_number }}</h1>
    <a href="{{ route('member.orders.index') }}" style="color:#7db64f;text-decoration:none;font-size:14px;font-weight:600;">← Siparişlerime Dön</a>
</div>

<div style="display:grid;grid-template-columns:2fr 1fr;gap:24px;margin-bottom:24px;">
    <!-- Sipariş Bilgileri -->
    <div style="background:#f9f9f9;border-radius:8px;padding:20px;">
        <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Sipariş Bilgileri</h2>
        <div style="display:grid;grid-template-columns:repeat(2, 1fr);gap:16px;">
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Sipariş Tarihi</div>
                <div style="font-weight:600;color:#414141;">{{ $order->created_at->format('d.m.Y H:i') }}</div>
            </div>
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Sipariş Durumu</div>
                <div style="font-weight:600;color:#414141;">
                    @if($order->status == 'pending') Beklemede
                    @elseif($order->status == 'confirmed') Onaylandı
                    @elseif($order->status == 'processing') Hazırlanıyor
                    @elseif($order->status == 'shipped') Kargoda
                    @elseif($order->status == 'delivered') Teslim Edildi
                    @elseif($order->status == 'cancelled') İptal Edildi
                    @endif
                </div>
            </div>
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Ödeme Durumu</div>
                <div style="font-weight:600;color:#414141;">
                    @if($order->payment_status == 'paid') Ödendi
                    @elseif($order->payment_status == 'pending') Ödeme Bekleniyor
                    @elseif($order->payment_status == 'failed') Ödeme Başarısız
                    @elseif($order->payment_status == 'refunded') İade Edildi
                    @endif
                </div>
            </div>
            <div>
                <div style="font-size:12px;color:#666;margin-bottom:4px;">Ödeme Yöntemi</div>
                <div style="font-weight:600;color:#414141;">{{ $order->payment_method ?? 'Belirtilmemiş' }}</div>
            </div>
        </div>
    </div>

    <!-- Özet -->
    <div style="background:#f9f9f9;border-radius:8px;padding:20px;height:fit-content;">
        <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Sipariş Özeti</h2>
        <div style="display:flex;flex-direction:column;gap:12px;">
            <div style="display:flex;justify-content:space-between;">
                <span style="color:#666;">Ara Toplam</span>
                <span style="font-weight:600;color:#414141;">{{ number_format($order->subtotal, 2) }} ₺</span>
            </div>
            <div style="display:flex;justify-content:space-between;">
                <span style="color:#666;">Kargo</span>
                <span style="font-weight:600;color:#414141;">{{ number_format($order->shipping_cost, 2) }} ₺</span>
            </div>
            @if($order->discount > 0)
            <div style="display:flex;justify-content:space-between;">
                <span style="color:#666;">İndirim</span>
                <span style="font-weight:600;color:#e74c3c;">-{{ number_format($order->discount, 2) }} ₺</span>
            </div>
            @endif
            <div style="border-top:2px solid #e5e7eb;padding-top:12px;margin-top:4px;">
                <div style="display:flex;justify-content:space-between;">
                    <span style="font-weight:600;color:#414141;font-size:16px;">Toplam</span>
                    <span style="font-weight:600;color:#7db64f;font-size:20px;">{{ number_format($order->total, 2) }} ₺</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Ürünler -->
<div style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;margin-bottom:24px;">
    <h2 style="margin:0 0 20px;color:#414141;font-size:18px;font-weight:600;">Sipariş Edilen Ürünler</h2>
    <div style="display:flex;flex-direction:column;gap:16px;">
        @foreach($order->items as $item)
            <div style="display:flex;gap:16px;padding:16px;background:#f9f9f9;border-radius:8px;">
                <div style="width:80px;height:80px;background:#e5e7eb;border-radius:4px;flex-shrink:0;display:flex;align-items:center;justify-content:center;color:#999;">
                    @if($item->product_image)
                        <img src="{{ $item->product_image }}" alt="{{ $item->product_name }}" style="width:100%;height:100%;object-fit:cover;border-radius:4px;">
                    @else
                        📦
                    @endif
                </div>
                <div style="flex:1;">
                    <div style="font-weight:600;color:#414141;margin-bottom:4px;">{{ $item->product_name }}</div>
                    <div style="font-size:14px;color:#666;margin-bottom:8px;">Adet: {{ $item->quantity }}</div>
                    <div style="font-weight:600;color:#7db64f;font-size:16px;">{{ number_format($item->total, 2) }} ₺</div>
                </div>
            </div>
        @endforeach
    </div>
</div>

<!-- Adresler -->
@if($order->deliveryAddress || $order->billingAddress)
<div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(300px, 1fr));gap:24px;">
    @if($order->deliveryAddress)
    <div style="background:#f9f9f9;border-radius:8px;padding:20px;">
        <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Teslimat Adresi</h2>
        <div style="color:#666;line-height:1.8;">
            <div style="font-weight:600;color:#414141;margin-bottom:8px;">{{ $order->deliveryAddress->first_name }} {{ $order->deliveryAddress->last_name }}</div>
            <div>{{ $order->deliveryAddress->address }}</div>
            <div>{{ $order->deliveryAddress->district }} / {{ $order->deliveryAddress->city }}</div>
            @if($order->deliveryAddress->postal_code)
            <div>Posta Kodu: {{ $order->deliveryAddress->postal_code }}</div>
            @endif
            <div>Tel: {{ $order->deliveryAddress->phone }}</div>
        </div>
    </div>
    @endif

    @if($order->billingAddress)
    <div style="background:#f9f9f9;border-radius:8px;padding:20px;">
        <h2 style="margin:0 0 16px;color:#414141;font-size:18px;font-weight:600;">Fatura Adresi</h2>
        <div style="color:#666;line-height:1.8;">
            <div style="font-weight:600;color:#414141;margin-bottom:8px;">{{ $order->billingAddress->first_name }} {{ $order->billingAddress->last_name }}</div>
            <div>{{ $order->billingAddress->address }}</div>
            <div>{{ $order->billingAddress->district }} / {{ $order->billingAddress->city }}</div>
            @if($order->billingAddress->postal_code)
            <div>Posta Kodu: {{ $order->billingAddress->postal_code }}</div>
            @endif
            <div>Tel: {{ $order->billingAddress->phone }}</div>
        </div>
    </div>
    @endif
</div>
@endif

@if($order->status == 'delivered')
<div style="margin-top:24px;text-align:center;">
    <a href="{{ route('member.returns.create', $order) }}" style="display:inline-block;padding:12px 24px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;">İade/Değişim Talebi Oluştur</a>
</div>
@endif
@endsection

