@extends('member.layout')
@section('member-content')
<h1 style="margin:0 0 30px;color:#414141;font-size:24px;font-weight:600;">Favorilerim</h1>

@if($favorites->count() > 0)
    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(200px, 1fr));gap:20px;">
        @foreach($favorites as $favorite)
            <div style="border:1px solid #e5e7eb;border-radius:8px;overflow:hidden;background:#fff;transition:box-shadow 0.3s;" onmouseover="this.style.boxShadow='0 4px 12px rgba(0,0,0,0.1)'" onmouseout="this.style.boxShadow='none'">
                <a href="{{ route('product.show', $favorite->product_slug) }}" style="text-decoration:none;color:inherit;">
                    <div style="width:100%;height:200px;background:#f0f0f0;display:flex;align-items:center;justify-content:center;overflow:hidden;">
                        @if($favorite->product_image)
                            <img src="{{ $favorite->product_image }}" alt="{{ $favorite->product_name }}" style="width:100%;height:100%;object-fit:cover;">
                        @else
                            <span style="font-size:48px;color:#999;">📦</span>
                        @endif
                    </div>
                    <div style="padding:16px;">
                        <div style="font-weight:600;color:#414141;margin-bottom:8px;font-size:14px;line-height:1.4;height:40px;overflow:hidden;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;">
                            {{ $favorite->product_name }}
                        </div>
                        @if($favorite->product_price)
                            <div style="font-weight:600;color:#7db64f;font-size:18px;margin-bottom:12px;">
                                {{ number_format($favorite->product_price, 2) }} ₺
                            </div>
                        @endif
                    </div>
                </a>
                <div style="padding:0 16px 16px;">
                    <form action="{{ route('member.favorites.destroy', $favorite) }}" method="POST" onsubmit="return confirm('Bu ürünü favorilerden kaldırmak istediğinize emin misiniz?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" style="width:100%;padding:10px;background:#e74c3c;color:#fff;border:none;border-radius:4px;font-size:14px;font-weight:600;cursor:pointer;">Favorilerden Kaldır</button>
                    </form>
                </div>
            </div>
        @endforeach
    </div>

    <div style="margin-top:30px;">
        {{ $favorites->links() }}
    </div>
@else
    <div style="text-align:center;padding:60px 20px;color:#666;">
        <div style="font-size:64px;margin-bottom:20px;">💚</div>
        <div style="font-size:20px;margin-bottom:12px;color:#414141;font-weight:600;">Henüz favori ürününüz bulunmuyor</div>
        <div style="font-size:14px;margin-bottom:24px;">Beğendiğiniz ürünleri favorilerinize ekleyin</div>
        <a href="{{ route('home') }}" style="display:inline-block;padding:12px 24px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;">Alışverişe Başla</a>
    </div>
@endif
@endsection

