@extends('member.layout')
@section('member-content')
<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;flex-wrap:wrap;gap:16px;">
    <h1 style="margin:0;color:#414141;font-size:24px;font-weight:600;">Adreslerim</h1>
    <a href="{{ route('member.addresses.create') }}" style="display:inline-block;padding:12px 24px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;">+ Yeni Adres Ekle</a>
</div>

@if($addresses->count() > 0)
    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(300px, 1fr));gap:20px;">
        @foreach($addresses as $address)
            <div style="border:2px solid {{ $address->is_default ? '#7db64f' : '#e5e7eb' }};border-radius:8px;padding:20px;background:#fff;position:relative;">
                @if($address->is_default)
                    <div style="position:absolute;top:12px;right:12px;background:#7db64f;color:#fff;padding:4px 12px;border-radius:4px;font-size:11px;font-weight:600;">Varsayılan</div>
                @endif
                
                <div style="margin-bottom:16px;">
                    <div style="font-weight:600;color:#414141;font-size:18px;margin-bottom:8px;">{{ $address->title }}</div>
                    <div style="color:#666;line-height:1.8;font-size:14px;">
                        <div style="font-weight:600;color:#414141;margin-bottom:4px;">{{ $address->first_name }} {{ $address->last_name }}</div>
                        <div>{{ $address->address }}</div>
                        <div>{{ $address->district }} / {{ $address->city }}</div>
                        @if($address->postal_code)
                        <div>Posta Kodu: {{ $address->postal_code }}</div>
                        @endif
                        <div>Tel: {{ $address->phone }}</div>
                    </div>
                </div>

                <div style="display:flex;gap:8px;flex-wrap:wrap;">
                    <a href="{{ route('member.addresses.edit', $address) }}" style="flex:1;display:inline-block;padding:10px;background:#f0f0f0;color:#414141;text-decoration:none;border-radius:4px;text-align:center;font-size:14px;font-weight:600;">Düzenle</a>
                    <form action="{{ route('member.addresses.destroy', $address) }}" method="POST" style="flex:1;margin:0;" onsubmit="return confirm('Bu adresi silmek istediğinize emin misiniz?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" style="width:100%;padding:10px;background:#e74c3c;color:#fff;border:none;border-radius:4px;font-size:14px;font-weight:600;cursor:pointer;">Sil</button>
                    </form>
                </div>
            </div>
        @endforeach
    </div>
@else
    <div style="text-align:center;padding:60px 20px;color:#666;">
        <div style="font-size:64px;margin-bottom:20px;">📍</div>
        <div style="font-size:20px;margin-bottom:12px;color:#414141;font-weight:600;">Henüz adres eklenmemiş</div>
        <div style="font-size:14px;margin-bottom:24px;">İlk adresinizi ekleyerek başlayın</div>
        <a href="{{ route('member.addresses.create') }}" style="display:inline-block;padding:12px 24px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;">Adres Ekle</a>
    </div>
@endif
@endsection

