@extends('member.layout')
@section('member-content')
<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;flex-wrap:wrap;gap:16px;">
    <h1 style="margin:0;color:#414141;font-size:24px;font-weight:600;">Adres Düzenle</h1>
    <a href="{{ route('member.addresses.index') }}" style="color:#7db64f;text-decoration:none;font-size:14px;font-weight:600;">← Adreslerime Dön</a>
</div>

<form method="POST" action="{{ route('member.addresses.update', $address) }}" style="max-width:600px;">
    @csrf
    @method('PUT')
    
    <div style="display:grid;grid-template-columns:1fr 1fr;gap:16px;margin-bottom:16px;">
        <div>
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Adres Başlığı <span style="color:#e74c3c;">*</span></label>
            <input type="text" name="title" value="{{ old('title', $address->title) }}" required placeholder="Ev, İş, vb." 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
        </div>
        <div>
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Adres Tipi <span style="color:#e74c3c;">*</span></label>
            <select name="type" required style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
                <option value="both" {{ old('type', $address->type) == 'both' ? 'selected' : '' }}>Teslimat & Fatura</option>
                <option value="delivery" {{ old('type', $address->type) == 'delivery' ? 'selected' : '' }}>Sadece Teslimat</option>
                <option value="billing" {{ old('type', $address->type) == 'billing' ? 'selected' : '' }}>Sadece Fatura</option>
            </select>
        </div>
    </div>

    <div style="display:grid;grid-template-columns:1fr 1fr;gap:16px;margin-bottom:16px;">
        <div>
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Ad <span style="color:#e74c3c;">*</span></label>
            <input type="text" name="first_name" value="{{ old('first_name', $address->first_name) }}" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
        </div>
        <div>
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Soyad <span style="color:#e74c3c;">*</span></label>
            <input type="text" name="last_name" value="{{ old('last_name', $address->last_name) }}" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
        </div>
    </div>

    <div style="margin-bottom:16px;">
        <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Telefon <span style="color:#e74c3c;">*</span></label>
        <input type="tel" name="phone" value="{{ old('phone', $address->phone) }}" required placeholder="05XX XXX XX XX" 
               style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
    </div>

    <div style="display:grid;grid-template-columns:1fr 1fr;gap:16px;margin-bottom:16px;">
        <div>
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">İl <span style="color:#e74c3c;">*</span></label>
            <input type="text" name="city" value="{{ old('city', $address->city) }}" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
        </div>
        <div>
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">İlçe <span style="color:#e74c3c;">*</span></label>
            <input type="text" name="district" value="{{ old('district', $address->district) }}" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
        </div>
    </div>

    <div style="margin-bottom:16px;">
        <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Adres <span style="color:#e74c3c;">*</span></label>
        <textarea name="address" required rows="3" 
                  style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;resize:vertical;">{{ old('address', $address->address) }}</textarea>
    </div>

    <div style="margin-bottom:16px;">
        <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Posta Kodu</label>
        <input type="text" name="postal_code" value="{{ old('postal_code', $address->postal_code) }}" 
               style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;">
    </div>

    <div style="margin-bottom:24px;">
        <label style="display:flex;align-items:center;gap:8px;cursor:pointer;">
            <input type="checkbox" name="is_default" value="1" {{ old('is_default', $address->is_default) ? 'checked' : '' }} style="width:18px;height:18px;cursor:pointer;">
            <span style="color:#414141;font-weight:600;">Varsayılan adres olarak ayarla</span>
        </label>
    </div>

    <div style="display:flex;gap:12px;">
        <button type="submit" style="flex:1;padding:14px 24px;background:#7db64f;color:#fff;border:none;border-radius:4px;font-size:16px;font-weight:600;cursor:pointer;">Güncelle</button>
        <a href="{{ route('member.addresses.index') }}" style="flex:1;padding:14px 24px;background:#f0f0f0;color:#414141;text-decoration:none;border-radius:4px;font-size:16px;font-weight:600;text-align:center;">İptal</a>
    </div>
</form>
@endsection

