@extends('layouts.app')
@section('content')
<div class="tm-auth-container" style="max-width:500px;margin:50px auto;padding:30px;background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);">
    <h2 style="text-align:center;margin-bottom:30px;color:#7db64f;font-size:28px;">Yeni Üye Kaydı</h2>
    
    @if(session('success'))
        <div style="background:#d4edda;color:#155724;padding:12px;border-radius:4px;margin-bottom:20px;">
            {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div style="background:#f8d7da;color:#721c24;padding:12px;border-radius:4px;margin-bottom:20px;">
            <ul style="margin:0;padding-left:20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('auth.register') }}" style="display:flex;flex-direction:column;gap:20px;">
        @csrf
        <div class="form-group">
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Ad Soyad <span style="color:#e74c3c;">*</span></label>
            <input type="text" name="name" value="{{ old('name') }}" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;transition:border-color 0.3s;"
                   onfocus="this.style.borderColor='#7db64f'" onblur="this.style.borderColor='#e5e7eb'">
        </div>
        <div class="form-group">
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">E-posta <span style="color:#e74c3c;">*</span></label>
            <input type="email" name="email" value="{{ old('email') }}" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;transition:border-color 0.3s;"
                   onfocus="this.style.borderColor='#7db64f'" onblur="this.style.borderColor='#e5e7eb'">
        </div>
        <div class="form-group">
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Telefon</label>
            <input type="tel" name="phone" value="{{ old('phone') }}" 
                   placeholder="05XX XXX XX XX"
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;transition:border-color 0.3s;"
                   onfocus="this.style.borderColor='#7db64f'" onblur="this.style.borderColor='#e5e7eb'">
        </div>
        <div class="form-group">
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Şifre <span style="color:#e74c3c;">*</span></label>
            <input type="password" name="password" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;transition:border-color 0.3s;"
                   onfocus="this.style.borderColor='#7db64f'" onblur="this.style.borderColor='#e5e7eb'">
            <small style="color:#666;font-size:12px;margin-top:4px;display:block;">En az 8 karakter olmalıdır</small>
        </div>
        <div class="form-group">
            <label style="display:block;margin-bottom:8px;font-weight:600;color:#414141;">Şifre Tekrar <span style="color:#e74c3c;">*</span></label>
            <input type="password" name="password_confirmation" required 
                   style="width:100%;padding:12px;border:2px solid #e5e7eb;border-radius:4px;font-size:14px;box-sizing:border-box;transition:border-color 0.3s;"
                   onfocus="this.style.borderColor='#7db64f'" onblur="this.style.borderColor='#e5e7eb'">
        </div>
        <div class="form-group" style="display:flex;align-items:flex-start;gap:8px;">
            <input type="checkbox" name="terms" id="terms" required style="width:18px;height:18px;cursor:pointer;margin-top:2px;flex-shrink:0;">
            <label for="terms" style="margin:0;cursor:pointer;color:#414141;font-size:14px;">
                <a href="{{ route('terms') }}" target="_blank" style="color:#7db64f;">Kullanım Koşulları</a> ve 
                <a href="{{ route('privacy') }}" target="_blank" style="color:#7db64f;">Gizlilik Politikası</a>'nı okudum, kabul ediyorum. <span style="color:#e74c3c;">*</span>
            </label>
        </div>
        <button type="submit" style="background:#7db64f;color:#fff;padding:14px 24px;border:none;border-radius:4px;font-size:16px;font-weight:600;cursor:pointer;transition:background 0.3s;width:100%;">
            Kayıt Ol
        </button>
        <p style="text-align:center;margin-top:20px;color:#414141;">
            Zaten üye misiniz? <a href="{{ route('auth.login') }}" style="color:#7db64f;text-decoration:none;font-weight:600;">Giriş yapın</a>
        </p>
    </form>
</div>

<style>
    @media (max-width: 640px) {
        .tm-auth-container {
            margin: 20px auto;
            padding: 20px;
        }
        .tm-auth-container h2 {
            font-size: 24px;
        }
    }
</style>
@endsection

