@extends('admin.layout')
@section('content')
<h1>Yeni Slider Ekle</h1>

<form method="POST" action="{{ route('admin.sliders.store') }}" class="mt">
    @csrf
    
    <div class="form-group">
        <label>Slider Adı *</label>
        <input type="text" name="name" value="{{ old('name') }}" required class="form-control" placeholder="Örn: Ana Slider, Haftanın Ürünleri">
    </div>

    <div class="form-group">
        <label>Slider Tipi *</label>
        <select name="type" class="form-control" required>
            <option value="banner" {{ old('type') == 'banner' ? 'selected' : '' }}>Banner (Görsel Slider)</option>
            <option value="product" {{ old('type') == 'product' ? 'selected' : '' }}>Ürün Slider</option>
        </select>
        <small>Banner: Görseller ve metinler için | Ürün Slider: Ürünler için</small>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="{{ old('order', 0) }}" class="form-control" min="0">
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                Aktif
            </label>
        </div>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Kaydet</button>
        <a class="btn secondary" href="{{ route('admin.sliders.index') }}">İptal</a>
    </div>
</form>
@endsection

