@extends('admin.layout')
@section('content')
<h1>Yeni Ürün Ekle</h1>

<form method="POST" action="{{ route('admin.products.store') }}" enctype="multipart/form-data" class="mt">
    @csrf
    
    <div class="form-row" style="display:grid;grid-template-columns:2fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Ürün Adı *</label>
            <input type="text" name="name" value="{{ old('name') }}" required class="form-control" placeholder="Örn: Organik Brokoli (500 gr)">
            <small>Ürün adı otomatik olarak slug'a dönüştürülecektir</small>
        </div>

        <div class="form-group">
            <label>Kategori</label>
            <select name="category_id" class="form-control">
                <option value="">Kategori Seçin</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>

    <div class="form-group">
        <label>Kısa Açıklama</label>
        <textarea name="description" rows="3" class="form-control" placeholder="Ürün hakkında kısa açıklama...">{{ old('description') }}</textarea>
        <small>Ürün kartlarında görünecek kısa açıklama</small>
    </div>

    <div class="form-group">
        <label>Detaylı Açıklama</label>
        <textarea name="description_detail" rows="8" class="form-control" placeholder="Ürün hakkında detaylı açıklama, besin değerleri, tarifler vb...">{{ old('description_detail') }}</textarea>
        <small>Ürün detay sayfasında "Açıklama" tab'ında görünecek detaylı içerik</small>
    </div>

    <div class="form-group">
        <label>Teslimat Bilgileri</label>
        <textarea name="delivery_info" rows="6" class="form-control" placeholder="Teslimat süresi, koşulları, muhafaza bilgileri vb...">{{ old('delivery_info') }}</textarea>
        <small>Ürün detay sayfasında "TESLİMAT" tab'ında görünecek içerik</small>
    </div>

    <div class="form-group">
        <label>Sertifika Bilgileri</label>
        <textarea name="certificates_info" rows="6" class="form-control" placeholder="Organik sertifika bilgileri, sertifika numaraları vb...">{{ old('certificates_info') }}</textarea>
        <small>Ürün detay sayfasında "SERTİFİKALAR" tab'ında görünecek içerik</small>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Fiyat (TL) *</label>
            <input type="number" name="price" value="{{ old('price') }}" required step="0.01" min="0" class="form-control" placeholder="99.95">
        </div>

        <div class="form-group">
            <label>İndirimli Fiyat (TL)</label>
            <input type="number" name="sale_price" value="{{ old('sale_price') }}" step="0.01" min="0" class="form-control" placeholder="79.95">
            <small>İndirimli fiyat, normal fiyattan küçük olmalıdır</small>
        </div>

        <div class="form-group">
            <label>SKU</label>
            <input type="text" name="sku" value="{{ old('sku') }}" class="form-control" placeholder="Ürün kodu">
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Ana Görsel</label>
            <input type="file" name="image" accept="image/*" class="form-control">
            <small>Ürünün ana görseli (JPEG, PNG, GIF, WebP - Max 2MB)</small>
        </div>

        <div class="form-group">
            <label>Galeri Görselleri</label>
            <input type="file" name="gallery[]" accept="image/*" multiple class="form-control">
            <small>Birden fazla görsel seçebilirsiniz</small>
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Çiftlik Adı</label>
            <input type="text" name="farm_name" value="{{ old('farm_name') }}" class="form-control" placeholder="Örn: Pulur Organik - Yalova">
        </div>

        <div class="form-group">
            <label>Menşei</label>
            <input type="text" name="origin" value="{{ old('origin') }}" class="form-control" placeholder="Örn: Mersin, Adana">
        </div>

        <div class="form-group">
            <label>Marka</label>
            <input type="text" name="brand" value="{{ old('brand') }}" class="form-control" placeholder="Marka adı">
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Ağırlık/Miktar</label>
            <input type="text" name="weight" value="{{ old('weight') }}" class="form-control" placeholder="Örn: 500 gr, 1 kg">
        </div>

        <div class="form-group">
            <label>Stok Miktarı</label>
            <input type="number" name="stock_quantity" value="{{ old('stock_quantity', 0) }}" min="0" class="form-control">
        </div>

        <div class="form-group">
            <label>Puan (0-5)</label>
            <input type="number" name="rating" value="{{ old('rating', 0) }}" min="0" max="5" class="form-control">
        </div>

        <div class="form-group">
            <label>Yorum Sayısı</label>
            <input type="number" name="review_count" value="{{ old('review_count', 0) }}" min="0" class="form-control">
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr 1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>
                <input type="checkbox" name="is_organic" value="1" {{ old('is_organic') ? 'checked' : '' }}>
                Organik Ürün
            </label>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }}>
                Öne Çıkan Ürün
            </label>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="in_stock" value="1" {{ old('in_stock', true) ? 'checked' : '' }}>
                Stokta Var
            </label>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                Aktif
            </label>
        </div>
    </div>

    <div class="form-group">
        <label>Sıra</label>
        <input type="number" name="order" value="{{ old('order', 0) }}" class="form-control" min="0">
        <small>Ürünlerin sıralaması (küçükten büyüğe)</small>
    </div>

    @php
        $weeklySlider = \App\Models\Slider::where('slug', 'haftanin-urunleri')->first();
    @endphp
    
    @if($weeklySlider)
        <div class="form-group" style="background:#f0f9f4;padding:15px;border-radius:8px;border:2px solid #73ae43;">
            <label style="font-weight:600;color:#333;margin-bottom:10px;display:block;">Haftanın Ürünleri Slider'ı</label>
            <div style="color:#666;margin-bottom:10px;">
                Ürünü kaydettikten sonra "Haftanın Ürünleri" slider'ına ekleyebilirsiniz.
            </div>
            <a href="{{ route('admin.sliders.edit', $weeklySlider) }}" class="btn" style="background:#73ae43;">Slider'ı Yönet</a>
        </div>
    @endif

    <div class="flex mt">
        <button type="submit" class="btn">Kaydet</button>
        <a class="btn secondary" href="{{ route('admin.products.index') }}">İptal</a>
    </div>
</form>
@endsection

