@extends('admin.layout')

@section('content')
<h1>Sipariş Yönetimi</h1>

@if(session('success'))
    <div style="background:#d4edda;color:#155724;padding:12px;border-radius:4px;margin-bottom:20px;">
        {{ session('success') }}
    </div>
@endif

<div style="margin-bottom:20px;">
    <form method="GET" action="{{ route('admin.orders.index') }}" style="display:flex;gap:10px;flex-wrap:wrap;">
        <select name="status" style="padding:8px;border:1px solid #ddd;border-radius:4px;">
            <option value="">Tüm Durumlar</option>
            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Beklemede</option>
            <option value="confirmed" {{ request('status') == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
            <option value="processing" {{ request('status') == 'processing' ? 'selected' : '' }}>Hazırlanıyor</option>
            <option value="shipped" {{ request('status') == 'shipped' ? 'selected' : '' }}>Kargoda</option>
            <option value="delivered" {{ request('status') == 'delivered' ? 'selected' : '' }}>Teslim Edildi</option>
            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>İptal Edildi</option>
        </select>
        <button type="submit" class="btn">Filtrele</button>
        <a href="{{ route('admin.orders.index') }}" class="btn secondary">Temizle</a>
    </form>
</div>

@if($orders->count() > 0)
    <table style="width:100%;border-collapse:collapse;background:#fff;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
        <thead>
            <tr style="background:#f5f5f5;">
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Sipariş No</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Müşteri</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Tutar</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Durum</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Ödeme</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">Tarih</th>
                <th style="padding:12px;text-align:left;border-bottom:2px solid #ddd;">İşlemler</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
                <tr style="border-bottom:1px solid #eee;">
                    <td style="padding:12px;">{{ $order->order_number }}</td>
                    <td style="padding:12px;">{{ $order->user->name }}<br><small style="color:#666;">{{ $order->user->email }}</small></td>
                    <td style="padding:12px;font-weight:600;color:#7db64f;">{{ number_format($order->total, 2) }} ₺</td>
                    <td style="padding:12px;">
                        <span style="padding:4px 12px;background:#f0f0f0;border-radius:4px;font-size:12px;">
                            @if($order->status == 'pending') Beklemede
                            @elseif($order->status == 'confirmed') Onaylandı
                            @elseif($order->status == 'processing') Hazırlanıyor
                            @elseif($order->status == 'shipped') Kargoda
                            @elseif($order->status == 'delivered') Teslim Edildi
                            @elseif($order->status == 'cancelled') İptal Edildi
                            @endif
                        </span>
                    </td>
                    <td style="padding:12px;">
                        <span style="padding:4px 12px;background:#e8f5e9;border-radius:4px;font-size:12px;">
                            @if($order->payment_status == 'paid') Ödendi
                            @elseif($order->payment_status == 'pending') Bekleniyor
                            @elseif($order->payment_status == 'failed') Başarısız
                            @elseif($order->payment_status == 'refunded') İade Edildi
                            @endif
                        </span>
                    </td>
                    <td style="padding:12px;color:#666;font-size:13px;">{{ $order->created_at->format('d.m.Y H:i') }}</td>
                    <td style="padding:12px;">
                        <a href="{{ route('admin.orders.show', $order) }}" class="btn" style="padding:6px 12px;font-size:12px;">Detay</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div style="margin-top:20px;">
        {{ $orders->links() }}
    </div>
@else
    <p style="padding:40px;text-align:center;color:#666;">Henüz sipariş bulunmuyor.</p>
@endif
@endsection

