@extends('admin.layout')

@section('content')
    <h1>Menü Yönetimi</h1>
    <p>Header/Footer menülerini düzenle, öğe ekle veya güncelle. Değişiklikler cache’den otomatik temizlenir.</p>

    <div class="grid grid-2 mt">
        <div>
            <h3>Yeni Menü Oluştur</h3>
            <form method="POST" action="{{ route('admin.menus.store') }}">
                @csrf
                <input name="name" placeholder="Menü adı (örn: Header)" required>
                <input name="slug" placeholder="Slug (örn: header)" required>
                <input name="location" placeholder="Konum (opsiyonel)">
                <label class="flex"><input type="checkbox" name="is_active" value="1" checked> Aktif</label>
                <button class="btn" type="submit">Kaydet</button>
            </form>
        </div>

        <div>
            <h3>Yeni Menü Öğesi</h3>
            <form method="POST" action="{{ route('admin.menus.items.store', ['menu' => optional($menus->first())->id]) }}">
                @csrf
                <select name="menu_id" onchange="this.form.action=this.form.action.replace(/menus\\/\\d+\\/items/, 'menus/'+this.value+'/items')">
                    @foreach($menus as $menu)
                        <option value="{{ $menu->id }}">{{ $menu->name }} ({{ $menu->slug }})</option>
                    @endforeach
                </select>
                <input name="title" placeholder="Başlık" required>
                <input name="url" placeholder="URL (dış link) — varsa route_name boş bırak">
                <input name="route_name" placeholder="Route adı (örn: home)">
                <input name="route_params" placeholder='Route parametreleri JSON (örn: {"slug":"ornek"})'>
                <input name="target" placeholder="Target (varsayılan: _self)">
                <select name="parent_id">
                    <option value="">Üst öğe yok</option>
                    @foreach($menus as $menu)
                        @foreach($menu->items as $mi)
                            <option value="{{ $mi->id }}">{{ $menu->name }} → {{ $mi->title }}</option>
                        @endforeach
                    @endforeach
                </select>
                <input type="number" name="order" value="0" min="0" placeholder="Sıra">
                <label class="flex"><input type="checkbox" name="is_active" value="1" checked> Aktif</label>
                <button class="btn" type="submit">Öğe Ekle</button>
            </form>
        </div>
    </div>

    <div class="mt">
        @foreach($menus as $menu)
            <div class="mt">
                <h3>{{ $menu->name }} <small>({{ $menu->slug }})</small></h3>
                @if($menu->items->isEmpty())
                    <p>Henüz öğe yok.</p>
                @else
                    <table>
                        <thead>
                            <tr>
                                <th>Başlık</th>
                                <th>URL</th>
                                <th>Route</th>
                                <th>Üst</th>
                                <th>Sıra</th>
                                <th>Aktif</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($menu->items as $item)
                                <tr>
                                    <td>{{ $item->title }}</td>
                                    <td>{{ $item->url }}</td>
                                    <td>{{ $item->route_name }}</td>
                                    <td>{{ optional($item->parent)->title }}</td>
                                    <td>{{ $item->order }}</td>
                                    <td><span class="badge">{{ $item->is_active ? 'Aktif' : 'Pasif' }}</span></td>
                                    <td class="flex">
                                        <form method="POST" action="{{ route('admin.menus.items.update', $item) }}">
                                            @csrf
                                            @method('PUT')
                                            <input type="hidden" name="title" value="{{ $item->title }}">
                                            <input type="hidden" name="url" value="{{ $item->url }}">
                                            <input type="hidden" name="route_name" value="{{ $item->route_name }}">
                                            <input type="hidden" name="route_params" value="{{ $item->route_params ? json_encode($item->route_params) : '' }}">
                                            <input type="hidden" name="parent_id" value="{{ $item->parent_id }}">
                                            <input type="hidden" name="order" value="{{ $item->order }}">
                                            <input type="hidden" name="target" value="{{ $item->target }}">
                                            <input type="hidden" name="is_active" value="{{ $item->is_active }}">
                                            <button class="btn secondary" type="submit">Yenile</button>
                                        </form>
                                        <form method="POST" action="{{ route('admin.menus.items.destroy', $item) }}">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn danger" type="submit" onclick="return confirm('Silinsin mi?')">Sil</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
        @endforeach
    </div>
@endsection


