@extends('admin.layout')
@section('content')
<h1>Kategori Yönetimi</h1>
<div class="mt">
    <a class="btn" href="{{ route('admin.categories.create') }}">Yeni Kategori Ekle</a>
</div>

@if(session('success'))
    <div class="alert alert-success mt">{{ session('success') }}</div>
@endif

@if($errors->any())
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="mt" style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;">
    <h2 style="margin:0 0 20px 0;font-size:18px;">Ana Kategoriler</h2>
    
    @foreach($categories->whereNull('parent_id') as $parentCategory)
        <div style="border:1px solid #e5e7eb;border-radius:6px;padding:15px;margin-bottom:15px;background:#f9fafb;">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px;">
                <div style="display:flex;align-items:center;gap:12px;">
                    <span style="font-size:24px;">{{ $parentCategory->icon ?? '📦' }}</span>
                    <div>
                        <strong style="font-size:16px;color:#1f2937;">{{ $parentCategory->name }}</strong>
                        <div style="font-size:12px;color:#6b7280;margin-top:2px;">
                            Slug: {{ $parentCategory->slug }} | 
                            Sıra: {{ $parentCategory->order }} |
                            @if($parentCategory->is_active)
                                <span style="color:green;">Aktif</span>
                            @else
                                <span style="color:red;">Pasif</span>
                            @endif
                        </div>
                    </div>
                </div>
                <div style="display:flex;gap:8px;">
                    <a class="btn btn-sm" href="{{ route('admin.categories.edit', $parentCategory) }}">Düzenle</a>
                    <form action="{{ route('admin.categories.destroy', $parentCategory) }}" method="POST" style="display:inline;" onsubmit="return confirm('Bu kategoriyi silmek istediğinize emin misiniz? Alt kategoriler ve ürünler de silinecek.');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                    </form>
                </div>
            </div>
            
            @if($parentCategory->children->count() > 0)
                <div style="margin-top:15px;padding-left:20px;border-left:3px solid #3b82f6;">
                    <strong style="font-size:14px;color:#6b7280;display:block;margin-bottom:10px;">Alt Kategoriler:</strong>
                    @foreach($parentCategory->children as $childCategory)
                        <div style="display:flex;align-items:center;justify-content:space-between;padding:10px;background:#fff;border:1px solid #e5e7eb;border-radius:4px;margin-bottom:8px;">
                            <div style="display:flex;align-items:center;gap:10px;">
                                <span style="font-size:20px;">{{ $childCategory->icon ?? '📦' }}</span>
                                <div>
                                    <strong style="font-size:14px;">{{ $childCategory->name }}</strong>
                                    <div style="font-size:11px;color:#9ca3af;">
                                        Slug: {{ $childCategory->slug }} | Sıra: {{ $childCategory->order }}
                                        @if($childCategory->is_active)
                                            <span style="color:green;">• Aktif</span>
                                        @else
                                            <span style="color:red;">• Pasif</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div style="display:flex;gap:6px;">
                                <a class="btn btn-sm" href="{{ route('admin.categories.edit', $childCategory) }}" style="font-size:12px;padding:4px 12px;">Düzenle</a>
                                <form action="{{ route('admin.categories.destroy', $childCategory) }}" method="POST" style="display:inline;" onsubmit="return confirm('Bu kategoriyi silmek istediğinize emin misiniz?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" style="font-size:12px;padding:4px 12px;">Sil</button>
                                </form>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    @endforeach
    
    @if($categories->whereNull('parent_id')->count() == 0)
        <p style="color:#6b7280;text-align:center;padding:40px;">Henüz kategori bulunmuyor. İlk kategoriyi oluşturun.</p>
    @endif
</div>
@endsection

