@extends('admin.layout')
@section('content')
<h1>Yeni Kategori Ekle</h1>

<form method="POST" action="{{ route('admin.categories.store') }}" enctype="multipart/form-data" class="mt">
    @csrf
    
    <div class="form-group">
        <label>Kategori Adı *</label>
        <input type="text" name="name" value="{{ old('name') }}" required class="form-control" placeholder="Örn: Taze Meyve">
        <small>Kategori adı otomatik olarak slug'a dönüştürülecektir</small>
    </div>

    <div class="form-group">
        <label>Ana Kategori</label>
        <select name="parent_id" class="form-control">
            <option value="">Ana Kategori (Üst kategori yok)</option>
            @foreach($parentCategories as $parent)
                <option value="{{ $parent->id }}" {{ old('parent_id') == $parent->id ? 'selected' : '' }}>
                    {{ $parent->name }}
                </option>
            @endforeach
        </select>
        <small>Boş bırakılırsa ana kategori olarak oluşturulur</small>
    </div>

    <div class="form-group">
        <label>İkon (Emoji veya Font Awesome class)</label>
        <input type="text" name="icon" value="{{ old('icon') }}" class="form-control" placeholder="🍎 veya fa fa-apple">
        <small>Emoji kullanabilirsiniz (örn: 🍎) veya Font Awesome class (örn: fa fa-apple)</small>
    </div>

    <div class="form-group">
        <label>Banner Görsel (500x500 px)</label>
        <input type="file" name="banner_image" accept="image/*" class="form-control">
        <small>Dropdown menüde sağ tarafta görünecek görsel. 500x500 piksel boyutunda olmalıdır.</small>
    </div>

    <div class="form-group">
        <label>Açıklama</label>
        <textarea name="description" rows="4" class="form-control" placeholder="Kategori hakkında kısa açıklama...">{{ old('description') }}</textarea>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="{{ old('order', 0) }}" class="form-control" min="0">
            <small>Kategorilerin sıralaması (küçükten büyüğe)</small>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                Aktif
            </label>
            <small style="display:block;margin-top:5px;">Kategori aktif olarak görünsün mü?</small>
        </div>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Kaydet</button>
        <a class="btn secondary" href="{{ route('admin.categories.index') }}">İptal</a>
    </div>
</form>
@endsection

