@extends('admin.layout')
@section('content')
<h1>Kampanya Yönetimi</h1>
<div class="mt">
    <a class="btn" href="{{ route('admin.campaigns.create') }}">Yeni Kampanya Ekle</a>
</div>

@if(session('success'))
    <div class="alert">{{ session('success') }}</div>
@endif

@if($errors->any())
    <div class="alert error">
        <ul style="margin:0;padding-left:20px;">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="mt">
    <table>
        <thead>
            <tr>
                <th>Görsel</th>
                <th>Başlık</th>
                <th>İndirim</th>
                <th>Tarih Aralığı</th>
                <th>Durum</th>
                <th>Sıra</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            @forelse($campaigns as $campaign)
                <tr>
                    <td>
                        @if($campaign->image)
                            <img src="{{ asset($campaign->image) }}" alt="{{ $campaign->title }}" style="width:60px;height:60px;object-fit:cover;border-radius:4px;">
                        @else
                            <span style="color:#9ca3af;">Görsel Yok</span>
                        @endif
                    </td>
                    <td>
                        <strong>{{ $campaign->title }}</strong>
                        <div style="font-size:12px;color:#6b7280;margin-top:4px;">
                            Slug: {{ $campaign->slug }}
                        </div>
                    </td>
                    <td>
                        @if($campaign->discount_percentage)
                            %{{ $campaign->discount_percentage }}
                        @elseif($campaign->discount_amount)
                            ₺{{ number_format($campaign->discount_amount, 2) }}
                        @else
                            <span style="color:#9ca3af;">-</span>
                        @endif
                    </td>
                    <td>
                        @if($campaign->start_date || $campaign->end_date)
                            <div style="font-size:12px;">
                                @if($campaign->start_date)
                                    Başlangıç: {{ $campaign->start_date->format('d.m.Y') }}<br>
                                @endif
                                @if($campaign->end_date)
                                    Bitiş: {{ $campaign->end_date->format('d.m.Y') }}
                                @endif
                            </div>
                        @else
                            <span style="color:#9ca3af;">Süresiz</span>
                        @endif
                    </td>
                    <td>
                        @if($campaign->is_active && $campaign->isCurrentlyActive())
                            <span style="color:green;font-weight:600;">Aktif</span>
                        @elseif($campaign->is_active)
                            <span style="color:orange;font-weight:600;">Beklemede</span>
                        @else
                            <span style="color:red;font-weight:600;">Pasif</span>
                        @endif
                    </td>
                    <td>{{ $campaign->order }}</td>
                    <td>
                        <div class="flex">
                            <a class="btn" href="{{ route('admin.campaigns.edit', $campaign) }}" style="font-size:12px;padding:6px 12px;">Düzenle</a>
                            <form action="{{ route('admin.campaigns.destroy', $campaign) }}" method="POST" style="display:inline;" onsubmit="return confirm('Bu kampanyayı silmek istediğinize emin misiniz?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn danger" style="font-size:12px;padding:6px 12px;">Sil</button>
                            </form>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" style="text-align:center;padding:40px;color:#6b7280;">
                        Henüz kampanya bulunmuyor. İlk kampanyayı oluşturun.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    
    <div style="margin-top:20px;">
        {{ $campaigns->links() }}
    </div>
</div>
@endsection

