<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Taze Meyve',
                'slug' => 'taze-meyve',
                'icon' => '🍎',
                'order' => 1,
                'is_active' => true,
                'children' => [
                    ['name' => 'Taze Meyveler', 'slug' => 'taze-meyveler', 'icon' => '🍎', 'order' => 1],
                    ['name' => 'Kuru Meyveler', 'slug' => 'kuru-meyveler', 'icon' => '🍇', 'order' => 2],
                    ['name' => 'Tropikal Meyveler', 'slug' => 'tropikal-meyveler', 'icon' => '🥭', 'order' => 3, 'children' => [
                        ['name' => 'Yaban Mersini', 'slug' => 'yaban-mersini', 'icon' => '🫐', 'order' => 1],
                        ['name' => 'Ananas', 'slug' => 'ananas', 'icon' => '🍍', 'order' => 2],
                        ['name' => 'Çarkıfelek', 'slug' => 'carkifelek', 'icon' => '🥝', 'order' => 3],
                        ['name' => 'Mango', 'slug' => 'mango', 'icon' => '🥭', 'order' => 4],
                    ]],
                ],
            ],
            [
                'name' => 'Taze Sebze',
                'slug' => 'taze-sebze',
                'icon' => '🌶️',
                'order' => 2,
                'is_active' => true,
            ],
            [
                'name' => 'Kahvaltılık Ürünler',
                'slug' => 'kahvaltilik-urunler',
                'icon' => '🧀',
                'order' => 3,
                'is_active' => true,
                'children' => [
                    ['name' => 'Peynirler', 'slug' => 'peynirler', 'icon' => '🧀', 'order' => 1, 'children' => [
                        ['name' => 'Beyaz Peynir', 'slug' => 'beyaz-peynir', 'icon' => '🧀', 'order' => 1],
                    ]],
                ],
            ],
            [
                'name' => 'Ekmek & Unlu Mamüller',
                'slug' => 'ekmek-unlu-mamuller',
                'icon' => '🥖',
                'order' => 4,
                'is_active' => true,
            ],
            [
                'name' => 'Zeytin & Zeytinyağı',
                'slug' => 'zeytin-zeytinyagi',
                'icon' => '🫒',
                'order' => 5,
                'is_active' => true,
            ],
            [
                'name' => 'Salça & Soslar',
                'slug' => 'salca-soslar',
                'icon' => '🍅',
                'order' => 6,
                'is_active' => true,
            ],
            [
                'name' => 'Kuru Gıdalar',
                'slug' => 'kuru-gidalar',
                'icon' => '🌾',
                'order' => 7,
                'is_active' => true,
            ],
            [
                'name' => 'Et, Tavuk ve Balık Ürünleri',
                'slug' => 'et-tavuk-balik',
                'icon' => '🍗',
                'order' => 8,
                'is_active' => true,
            ],
            [
                'name' => 'Taze Sepetler',
                'slug' => 'taze-sepetler',
                'icon' => '🛒',
                'order' => 9,
                'is_active' => true,
            ],
            [
                'name' => 'Organik Ürünler',
                'slug' => 'organik-urunler',
                'icon' => '🌿',
                'order' => 10,
                'is_active' => true,
            ],
            [
                'name' => 'Temizlik ve Kişisel Bakım',
                'slug' => 'temizlik-kisisel-bakim',
                'icon' => '🧴',
                'order' => 11,
                'is_active' => true,
            ],
        ];

        foreach ($categories as $categoryData) {
            $children = $categoryData['children'] ?? [];
            unset($categoryData['children']);
            
            $category = Category::updateOrCreate(
                ['slug' => $categoryData['slug']],
                $categoryData
            );

            foreach ($children as $childData) {
                $grandChildren = $childData['children'] ?? [];
                unset($childData['children']);
                $childData['parent_id'] = $category->id;
                
                $child = Category::updateOrCreate(
                    ['slug' => $childData['slug']],
                    $childData
                );

                foreach ($grandChildren as $grandChildData) {
                    $grandChildData['parent_id'] = $child->id;
                    Category::updateOrCreate(
                        ['slug' => $grandChildData['slug']],
                        $grandChildData
                    );
                }
            }
        }
    }
}
