<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('site_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->timestamps();
        });
        
        // Varsayılan ayarları ekle
        DB::table('site_settings')->insert([
            ['key' => 'site_name', 'value' => 'Tazemasa', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'site_logo', 'value' => '/logo.png', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'site_description', 'value' => 'Doğadan geldiği gibi, saf, zehirsiz, katkısız, hayata saygılı ürünlerin adresi.', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'site_keywords', 'value' => 'tazemasa, Taze Masa', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'meta_title', 'value' => 'tazemasa | Mutfak Alışverişi, Meyve, Sebze, Kahvaltılık ve Organik Ürünler', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'meta_description', 'value' => 'Doğadan geldiği gibi, saf, zehirsiz, katkısız, hayata saygılı ürünlerin adresi. İyi ye, iyi yaşa.', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'meta_keywords', 'value' => 'tazemasa, Taze Masa', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('site_settings');
    }
};
