<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SiteSetting;
use Illuminate\Support\Facades\Storage;

class SiteSettingsController extends Controller
{
    public function index()
    {
        $settings = \App\Models\SiteSetting::all()->pluck('value', 'key');
        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            // Genel Ayarlar
            'site_name' => ['required', 'string', 'max:255'],
            'site_logo' => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
            'site_favicon' => ['nullable', 'image', 'mimes:png,ico', 'max:1024'],
            'site_description' => ['nullable', 'string'],
            'site_keywords' => ['nullable', 'string'],
            'copyright_text' => ['nullable', 'string'],
            
            // SEO Ayarları
            'meta_title' => ['nullable', 'string', 'max:255'],
            'meta_description' => ['nullable', 'string'],
            'meta_keywords' => ['nullable', 'string'],
            
            // İletişim Bilgileri
            'contact_phone' => ['nullable', 'string', 'max:255'],
            'contact_email' => ['nullable', 'email', 'max:255'],
            'contact_address' => ['nullable', 'string'],
            'contact_working_hours' => ['nullable', 'string', 'max:255'],
            
            // Sosyal Medya
            'social_facebook' => ['nullable', 'url', 'max:255'],
            'social_instagram' => ['nullable', 'url', 'max:255'],
            'social_twitter' => ['nullable', 'url', 'max:255'],
            'social_youtube' => ['nullable', 'url', 'max:255'],
            'social_linkedin' => ['nullable', 'url', 'max:255'],
            
            // Kargo Ayarları
            'shipping_free_threshold' => ['nullable', 'numeric', 'min:0'],
            'shipping_cost' => ['nullable', 'numeric', 'min:0'],
            'shipping_delivery_days' => ['nullable', 'string', 'max:255'],
            'min_order_amount' => ['nullable', 'numeric', 'min:0'],
            
            // Ödeme Ayarları
            'payment_methods' => ['nullable', 'string'],
            'bank_accounts' => ['nullable', 'string'],
            
            // İade Politikası
            'return_policy_days' => ['nullable', 'integer', 'min:0'],
            'return_policy_text' => ['nullable', 'string'],
            
            // Analitik
            'google_analytics_id' => ['nullable', 'string', 'max:255'],
            'facebook_pixel_id' => ['nullable', 'string', 'max:255'],
            'google_tag_manager_id' => ['nullable', 'string', 'max:255'],
            
            // E-posta Ayarları
            'email_from_name' => ['nullable', 'string', 'max:255'],
            'email_from_address' => ['nullable', 'email', 'max:255'],
            
            // Para Puan Ayarları
            'para_puan_rate' => ['nullable', 'numeric', 'min:0'],
            'para_puan_min_usage' => ['nullable', 'numeric', 'min:0'],
            
            // Bakım Modu
            'maintenance_mode' => ['nullable', 'boolean'],
            'maintenance_message' => ['nullable', 'string'],
        ]);

        foreach ($validated as $key => $value) {
            // Dosya yükleme işlemleri
            if ($key === 'site_logo' && $request->hasFile('site_logo')) {
                $file = $request->file('site_logo');
                $filename = 'logo.' . $file->getClientOriginalExtension();
                $file->move(public_path(), $filename);
                SiteSetting::set($key, '/' . $filename);
            } elseif ($key === 'site_favicon' && $request->hasFile('site_favicon')) {
                $file = $request->file('site_favicon');
                $filename = 'favicon.png';
                $file->move(public_path(), $filename);
                SiteSetting::set($key, '/' . $filename);
            } elseif ($key !== 'site_logo' && $key !== 'site_favicon') {
                // Boolean değerleri düzgün kaydet
                if ($key === 'maintenance_mode') {
                    SiteSetting::set($key, $value ? '1' : '0');
                } else {
                    SiteSetting::set($key, $value);
                }
            }
        }

        return redirect()->route('admin.settings.index')->with('success', 'Site ayarları başarıyla güncellendi.');
    }
}
