<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ReturnRequest;
use Illuminate\Http\Request;

class ReturnManagementController extends Controller
{
    public function index(Request $request)
    {
        $query = ReturnRequest::with(['user', 'order', 'orderItem']);

        if ($request->has('status') && $request->status) {
            $query->where('status', $request->status);
        }

        $returns = $query->latest()->paginate(20);

        return view('admin.returns.index', compact('returns'));
    }

    public function show(ReturnRequest $return)
    {
        $return->load(['user', 'order.items', 'orderItem']);
        return view('admin.returns.show', compact('return'));
    }

    public function updateStatus(Request $request, ReturnRequest $return)
    {
        $validated = $request->validate([
            'status' => ['required', 'in:pending,approved,rejected,processing,completed'],
            'admin_notes' => ['nullable', 'string'],
        ]);

        $return->update($validated);

        return back()->with('success', 'İade talebi durumu güncellendi.');
    }
}
