﻿
<?php $__env->startSection('content'); ?>
    <style>
        .home-wrapper { max-width: 1200px; margin: 0 auto; padding: 16px; }
        
        /* Sliders Container */
        .sliders-container { display: grid; grid-template-columns: 2fr 1fr; gap: 20px; margin-bottom: 30px; }
        @media (max-width: 992px) {
            .sliders-container { grid-template-columns: 1fr; }
        }
        
        /* Hero Slider */
        .hero-slider { position: relative; width: 100%; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        .hero-slider-container { position: relative; width: 100%; height: 400px; overflow: hidden; background: #000; margin: 0; padding: 0; }
        .hero-slide { position: absolute; width: 100%; height: 100%; opacity: 0; transition: opacity 0.6s ease-in-out; top: 0; left: 0; margin: 0; padding: 0; }
        .hero-slide.active { opacity: 1; z-index: 2; }
        .hero-slide a { display: block; width: 100%; height: 100%; position: relative; margin: 0; padding: 0; line-height: 0; }
        .hero-slide img { width: 100%; height: 100%; object-fit: cover; object-position: center center; display: block; margin: 0; padding: 0; vertical-align: top; }
        .hero-slide-content { position: absolute; bottom: 0; left: 0; right: 0; background: linear-gradient(to top, rgba(0,0,0,0.7), transparent); padding: 40px 30px 30px; color: #fff; z-index: 5; }
        .hero-slide-content h2 { font-size: 32px; font-weight: 700; margin-bottom: 10px; text-shadow: 2px 2px 4px rgba(0,0,0,0.5); }
        .hero-slide-content p { font-size: 18px; margin: 0; }
        .hero-nav { position: absolute; top: 50%; transform: translateY(-50%); background: rgba(255,255,255,0.9); width: 45px; height: 45px; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer; z-index: 10; transition: all 0.3s; }
        .hero-nav:hover { background: #73ae43; color: #fff; }
        .hero-nav.prev { left: 20px; }
        .hero-nav.next { right: 20px; }
        .hero-dots { position: absolute; bottom: 20px; left: 50%; transform: translateX(-50%); display: flex; gap: 8px; z-index: 10; }
        .hero-dot { width: 12px; height: 12px; border-radius: 50%; background: rgba(255,255,255,0.5); cursor: pointer; transition: all 0.3s; }
        .hero-dot.active { background: #73ae43; width: 30px; border-radius: 6px; }
        
        /* Weekly Products Slider */
        .weekly-slider { background: #f0f9f4; border-radius: 8px; padding: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); height: 400px; position: relative; overflow: hidden; }
        .weekly-slider-header { background: #73ae43; color: #fff; padding: 12px 20px; border-radius: 6px; margin-bottom: 15px; font-weight: 600; font-size: 16px; text-align: center; }
        .weekly-slider-container { position: relative; height: calc(100% - 60px); overflow: hidden; }
        .weekly-slide { position: absolute; width: 100%; height: 100%; opacity: 0; transition: opacity 0.6s ease-in-out; display: flex; flex-direction: column; }
        .weekly-slide.active { opacity: 1; z-index: 2; }
        .weekly-slide-image { width: 100%; height: 180px; object-fit: contain; object-position: center center; border-radius: 6px; margin-bottom: 12px; background: #fff; padding: 5px; }
        .weekly-slide-info { flex: 1; }
        .weekly-slide-name { font-weight: 600; font-size: 14px; color: #333; margin-bottom: 8px; line-height: 1.4; }
        .weekly-slide-rating { display: flex; gap: 2px; margin-bottom: 8px; }
        .weekly-slide-rating .star { font-size: 14px; color: #ddd; }
        .weekly-slide-rating .star.filled { color: #ffc107; }
        .weekly-slide-price { font-weight: 700; color: #73ae43; font-size: 18px; }
        .weekly-slide-old-price { color: #999; text-decoration: line-through; font-size: 13px; margin-top: 4px; }
        .weekly-slide-btn { background: #ff6b35; color: #fff; padding: 10px; border-radius: 6px; text-align: center; text-decoration: none; font-weight: 600; font-size: 13px; margin-top: 10px; display: block; transition: all 0.3s; }
        .weekly-slide-btn:hover { background: #e55a2b; }
        .weekly-nav { position: absolute; top: 50%; transform: translateY(-50%); background: rgba(115,174,67,0.9); color: #fff; width: 32px; height: 32px; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer; z-index: 10; transition: all 0.3s; }
        .weekly-nav:hover { background: #5a8a35; }
        .weekly-nav.prev { left: 10px; }
        .weekly-nav.next { right: 10px; }
        .weekly-dots { position: absolute; bottom: 10px; left: 50%; transform: translateX(-50%); display: flex; gap: 6px; z-index: 10; }
        .weekly-dot { width: 8px; height: 8px; border-radius: 50%; background: rgba(115,174,67,0.5); cursor: pointer; transition: all 0.3s; }
        .weekly-dot.active { background: #73ae43; width: 20px; border-radius: 4px; }
        
        /* Sections */
        .home-section { margin-top: 40px; }
        .home-section h2 { font-size: 24px; font-weight: 700; margin-bottom: 20px; color: #333; padding-bottom: 10px; border-bottom: 3px solid #73ae43; }
        
        /* Weekly Product */
        .weekly-box { background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); border-radius: 12px; padding: 20px; display: flex; gap: 20px; align-items: center; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        .weekly-box img { width: 120px; height: 120px; object-fit: cover; border-radius: 8px; border: 3px solid #fff; }
        .weekly-box .info { flex: 1; }
        .weekly-box .name { font-size: 18px; font-weight: 600; color: #333; margin-bottom: 8px; }
        .weekly-box .price { font-size: 24px; font-weight: 700; color: #73ae43; }
        .weekly-box .old { color: #999; text-decoration: line-through; font-size: 16px; margin-top: 4px; }
        .weekly-box .btn { background: #73ae43; color: #fff; padding: 12px 24px; border-radius: 6px; font-weight: 600; text-decoration: none; transition: all 0.3s; }
        .weekly-box .btn:hover { background: #5a8a35; transform: translateY(-2px); box-shadow: 0 4px 8px rgba(115,174,67,0.3); }
        
        /* Product Grid */
        .home-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 20px; }
        .home-card { background: #fff; border: 1px solid #e5e7eb; border-radius: 12px; overflow: hidden; transition: all 0.3s; position: relative; }
        .home-card:hover { transform: translateY(-5px); box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        
        .home-card-image-wrapper { position: relative; width: 100%; padding-top: 100%; background: #f9fafb; }
        .home-card-image-wrapper img { position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; }
        
        .home-card-badges { position: absolute; top: 10px; left: 10px; display: flex; flex-direction: column; gap: 8px; z-index: 2; }
        .badge-organic { background: #10b981; color: #fff; padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; display: flex; align-items: center; gap: 4px; }
        .badge-discount { background: #10b981; color: #fff; padding: 6px 10px; border-radius: 50%; font-size: 12px; font-weight: 700; width: 45px; height: 45px; display: flex; align-items: center; justify-content: center; }
        
        .home-card-info { padding: 15px; }
        .home-card-rating { display: flex; align-items: center; gap: 4px; margin-bottom: 8px; }
        .home-card-rating .stars { display: flex; gap: 2px; }
        .home-card-rating .star { font-size: 16px; color: #ddd; }
        .home-card-rating .star.filled { color: #ffc107; }
        .home-card .name { font-weight: 600; font-size: 14px; color: #333; min-height: 40px; line-height: 1.4; margin-bottom: 8px; }
        .home-card-farm { font-size: 12px; color: #666; margin-bottom: 8px; }
        .home-card-price-section { margin-bottom: 12px; }
        .home-card .price { font-weight: 700; color: #73ae43; font-size: 18px; }
        .home-card .old { color: #999; text-decoration: line-through; font-size: 13px; margin-top: 4px; }
        .home-card-actions { display: flex; gap: 8px; align-items: center; margin-top: 12px; }
        .home-card-quantity { display: flex; align-items: center; gap: 4px; border: 1px solid #e5e7eb; border-radius: 6px; padding: 2px 4px; flex-shrink: 0; }
        .home-card-qty-btn { width: 24px; height: 24px; border: none; background: #f0f9f4; color: #73ae43; border-radius: 4px; cursor: pointer; font-size: 14px; display: flex; align-items: center; justify-content: center; padding: 0; }
        .home-card-qty-btn:hover { background: #d1fae5; }
        .home-card-qty-input { width: 32px; height: 24px; border: none; text-align: center; font-size: 12px; font-weight: 600; padding: 0; }
        .home-card .btn { flex: 1; background: #ff6b35; color: #fff; padding: 10px; border-radius: 6px; font-size: 13px; text-align: center; text-decoration: none; font-weight: 600; transition: all 0.3s; border: none; cursor: pointer; }
        .home-card .btn:hover { background: #e55a2b; transform: translateY(-2px); }
        
        /* Tüm karta tıklanabilir yap */
        .home-card-link { text-decoration: none; color: inherit; display: block; }
        .home-card-link:hover { text-decoration: none; }
        .home-card-info { cursor: pointer; }
        .home-card-actions { cursor: default; }
        .home-card-actions * { cursor: pointer; }
        .home-card-actions button, .home-card-actions input { cursor: pointer; }

        /* Mobil uyum */
        @media (max-width: 992px) {
            .home-wrapper { padding: 12px; }
            .sliders-container { grid-template-columns: 1fr; gap: 15px; }
            .hero-slider-container { height: 280px; }
            .weekly-slider { height: auto; min-height: 350px; }
            .hero-slide-content { padding: 24px 18px; }
            .hero-slide-content h2 { font-size: 24px; }
            .hero-slide-content p { font-size: 15px; }
            .home-section { margin-top: 28px; }
            .home-section h2 { font-size: 20px; padding-bottom: 8px; }
        }

        @media (max-width: 640px) {
            .hero-slider { border-radius: 0; box-shadow: none; }
            .hero-slider-container { height: 220px; }
            .hero-nav { width: 36px; height: 36px; }
            .hero-dots { bottom: 12px; }
            .weekly-box { padding: 14px; gap: 12px; }
            .weekly-box .name { font-size: 16px; }
            .weekly-box .price { font-size: 20px; }
            .home-grid { grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 14px; }
            .home-card-image-wrapper { padding-top: 100%; }
            .home-card-info { padding: 12px; }
            .home-card .btn { padding: 9px; font-size: 12px; }
        }
    </style>

    <div class="home-wrapper">
        <!-- Sliders Container -->
        <div class="sliders-container">
            <!-- Main Hero Slider -->
            <div class="hero-slider">
                <?php if($mainSlider && $mainSlider->activeItems->count() > 0): ?>
                    <div class="hero-slider-container" id="mainSlider">
                        <?php $__currentLoopData = $mainSlider->activeItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="hero-slide <?php echo e($index === 0 ? 'active' : ''); ?>">
                                <a href="<?php echo e($item->link ?? '#'); ?>">
                                    <img src="<?php echo e($item->image ? asset($item->image) : asset('images/placeholder.png')); ?>" alt="<?php echo e($item->title); ?>">
                                    <?php if($item->title || $item->description): ?>
                                        <div class="hero-slide-content">
                                            <?php if($item->title): ?>
                                                <h2><?php echo e($item->title); ?></h2>
                                            <?php endif; ?>
                                            <?php if($item->description): ?>
                                                <p><?php echo e($item->description); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($mainSlider->activeItems->count() > 1): ?>
                            <div class="hero-nav prev" onclick="changeMainSlide(-1)">‹</div>
                            <div class="hero-nav next" onclick="changeMainSlide(1)">›</div>
                            <div class="hero-dots">
                                <?php $__currentLoopData = $mainSlider->activeItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="hero-dot <?php echo e($index === 0 ? 'active' : ''); ?>" onclick="goToMainSlide(<?php echo e($index); ?>)"></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="hero-slider-container">
                        <div class="hero-slide active">
                            <a href="#">
                                <img src="https://static.ticimax.cloud/3140/uploads/sayfatasarim/sayfa1/3bfe12c8-2913-4992-a6e2-6bd1ba23ba55.jpg" alt="Avokado Özel Fiyat">
                                <div class="hero-slide-content">
                                    <h2>Avokado</h2>
                                    <p>Bugüne Özel Fırsatlar</p>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Weekly Products Slider -->
            <div class="weekly-slider">
                <div class="weekly-slider-header">Haftanın Ürünleri</div>
                <?php if($weeklySlider && $weeklySlider->activeItems->count() > 0): ?>
                    <div class="weekly-slider-container" id="weeklySlider">
                        <?php $__currentLoopData = $weeklySlider->activeItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->product): ?>
                                <div class="weekly-slide <?php echo e($index === 0 ? 'active' : ''); ?>">
                                    <img src="<?php echo e($item->product->image ? asset($item->product->image) : asset('images/placeholder.png')); ?>" alt="<?php echo e($item->product->name); ?>" class="weekly-slide-image">
                                    <div class="weekly-slide-info">
                                        <div class="weekly-slide-name"><?php echo e($item->product->name); ?></div>
                                        <?php
                                            $avgRating = $item->product->average_rating ?? $item->product->rating;
                                            $fullStars = floor($avgRating);
                                        ?>
                                        <div class="weekly-slide-rating">
                                            <?php for($i = 0; $i < 5; $i++): ?>
                                                <?php if($i < $fullStars): ?>
                                                    <span class="star filled">★</span>
                                                <?php else: ?>
                                                    <span class="star">☆</span>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <div class="weekly-slide-price">
                                            <?php if($item->product->sale_price): ?>
                                                <?php echo e(number_format($item->product->sale_price, 2, ',', '.')); ?> TL
                                            <?php else: ?>
                                                <?php echo e(number_format($item->product->price, 2, ',', '.')); ?> TL
                                            <?php endif; ?>
                                        </div>
                                        <?php if($item->product->sale_price && $item->product->price > $item->product->sale_price): ?>
                                            <div class="weekly-slide-old-price"><?php echo e(number_format($item->product->price, 2, ',', '.')); ?> TL</div>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('product.show', $item->product->slug)); ?>" class="weekly-slide-btn">Ürüne Git</a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($weeklySlider->activeItems->count() > 1): ?>
                            <div class="weekly-nav prev" onclick="changeWeeklySlide(-1)">‹</div>
                            <div class="weekly-nav next" onclick="changeWeeklySlide(1)">›</div>
                            <div class="weekly-dots">
                                <?php $__currentLoopData = $weeklySlider->activeItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($item->product): ?>
                                        <span class="weekly-dot <?php echo e($index === 0 ? 'active' : ''); ?>" onclick="goToWeeklySlide(<?php echo e($index); ?>)"></span>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="weekly-slider-container">
                        <div style="text-align:center;padding:40px;color:#666;">
                            <p>Haftanın ürünleri için slider oluşturun.</p>
                            <a href="<?php echo e(route('admin.sliders.create')); ?>" style="color:#73ae43;text-decoration:none;">Slider Oluştur</a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <?php
            $sections = [
                'Mevsim Ürünleri' => $mevsim ?? collect(),
                'En Çok Satanlar' => $cokSatan ?? collect(),
                'Yeni Ürünler' => $yeni ?? collect(),
            ];
        ?>

        <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $title => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($items->count()): ?>
                <div class="home-section">
                    <h2><?php echo e($title); ?></h2>
                    <div class="home-grid">
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="home-card">
                                <a href="<?php echo e(route('product.show', ['slug' => $product->slug])); ?>" class="home-card-link">
                                    <div class="home-card-image-wrapper">
                                        <img src="<?php echo e($product->image ? asset($product->image) : asset('images/placeholder.png')); ?>" alt="<?php echo e($product->name); ?>">
                                        <div class="home-card-badges">
                                            <?php if($product->is_organic): ?>
                                                <div class="badge-organic">
                                                    <span>🌿</span>
                                                    <span>organik</span>
                                                </div>
                                            <?php endif; ?>
                                            <?php if($product->sale_price && $product->price > $product->sale_price): ?>
                                                <?php
                                                    $discount = round((($product->price - $product->sale_price) / $product->price) * 100);
                                                ?>
                                                <div class="badge-discount">%<?php echo e($discount); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="home-card-info" onclick="event.stopPropagation();">
                                    <div class="home-card-rating">
                                        <?php
                                            $avgRating = $product->average_rating ?? $product->rating;
                                            $fullStars = floor($avgRating);
                                        ?>
                                        <?php for($i = 0; $i < 5; $i++): ?>
                                            <?php if($i < $fullStars): ?>
                                                <span class="star filled">★</span>
                                            <?php else: ?>
                                                <span class="star">☆</span>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>
                                        <div class="name"><?php echo e($product->name); ?></div>
                                        <?php if($product->farm_name || $product->origin): ?>
                                            <div class="home-card-farm">
                                                <?php if($product->farm_name): ?>
                                                    <?php echo e($product->farm_name); ?>

                                                <?php endif; ?>
                                                <?php if($product->origin): ?>
                                                    <?php if($product->farm_name): ?> - <?php endif; ?>
                                                    <?php echo e($product->origin); ?>

                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="home-card-price-section">
                                            <div class="price">
                                                <?php if($product->sale_price): ?>
                                                    <?php echo e(number_format($product->sale_price, 2, ',', '.')); ?> TL
                                                <?php else: ?>
                                                    <?php echo e(number_format($product->price, 2, ',', '.')); ?> TL
                                                <?php endif; ?>
                                            </div>
                                            <?php if($product->sale_price && $product->price > $product->sale_price): ?>
                                                <div class="old"><?php echo e(number_format($product->price, 2, ',', '.')); ?> TL</div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </a>
                                <div class="home-card-actions" onclick="event.stopPropagation();">
                                    <div class="home-card-quantity">
                                        <button class="home-card-qty-btn" onclick="event.stopPropagation(); decreaseQty(<?php echo e($product->id); ?>)">-</button>
                                        <input type="number" id="qty-<?php echo e($product->id); ?>" class="home-card-qty-input" value="1" min="1" max="<?php echo e($product->stock_quantity > 0 ? $product->stock_quantity : 99); ?>" onclick="event.stopPropagation();">
                                        <button class="home-card-qty-btn" onclick="event.stopPropagation(); increaseQty(<?php echo e($product->id); ?>)">+</button>
                                    </div>
                                    <button class="btn" onclick="event.stopPropagation(); addToCart(<?php echo e($product->id); ?>)" <?php echo e(!$product->in_stock ? 'disabled style="opacity:0.5;"' : ''); ?>>
                                        <?php echo e($product->in_stock ? 'SEPETE EKLE' : 'STOKTA YOK'); ?>

                                    </button>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <script>
        // Main Slider
        let currentMainSlide = 0;
        const mainSlides = document.querySelectorAll('#mainSlider .hero-slide');
        const mainDots = document.querySelectorAll('#mainSlider .hero-dot');
        const totalMainSlides = mainSlides.length;

        function showMainSlide(n) {
            if (totalMainSlides === 0) return;
            mainSlides.forEach(slide => slide.classList.remove('active'));
            mainDots.forEach(dot => dot.classList.remove('active'));
            
            currentMainSlide = (n + totalMainSlides) % totalMainSlides;
            mainSlides[currentMainSlide].classList.add('active');
            if (mainDots[currentMainSlide]) {
                mainDots[currentMainSlide].classList.add('active');
            }
        }

        function changeMainSlide(direction) {
            showMainSlide(currentMainSlide + direction);
        }

        function goToMainSlide(n) {
            showMainSlide(n);
        }

        // Weekly Slider
        let currentWeeklySlide = 0;
        const weeklySlides = document.querySelectorAll('#weeklySlider .weekly-slide');
        const weeklyDots = document.querySelectorAll('#weeklySlider .weekly-dot');
        const totalWeeklySlides = weeklySlides.length;

        function showWeeklySlide(n) {
            if (totalWeeklySlides === 0) return;
            weeklySlides.forEach(slide => slide.classList.remove('active'));
            weeklyDots.forEach(dot => dot.classList.remove('active'));
            
            currentWeeklySlide = (n + totalWeeklySlides) % totalWeeklySlides;
            weeklySlides[currentWeeklySlide].classList.add('active');
            if (weeklyDots[currentWeeklySlide]) {
                weeklyDots[currentWeeklySlide].classList.add('active');
            }
        }

        function changeWeeklySlide(direction) {
            showWeeklySlide(currentWeeklySlide + direction);
        }

        function goToWeeklySlide(n) {
            showWeeklySlide(n);
        }

        // Otomatik slider
        if (totalMainSlides > 1) {
            setInterval(() => {
                changeMainSlide(1);
            }, 5000);
        }

        if (totalWeeklySlides > 1) {
            setInterval(() => {
                changeWeeklySlide(1);
            }, 4000);
        }

        function increaseQty(productId) {
            const input = document.getElementById('qty-' + productId);
            const max = parseInt(input.getAttribute('max')) || 99;
            const current = parseInt(input.value) || 1;
            if (current < max) {
                input.value = current + 1;
            }
        }

        function decreaseQty(productId) {
            const input = document.getElementById('qty-' + productId);
            const current = parseInt(input.value) || 1;
            if (current > 1) {
                input.value = current - 1;
            }
        }

        function addToCart(productId) {
            const quantity = document.getElementById('qty-' + productId).value;
            // Backend entegrasyonu için hazır - AJAX çağrısı yapılacak
            alert('Ürün sepete eklendi! (Backend entegrasyonu sonrası aktif olacak)');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/home.blade.php ENDPATH**/ ?>