
<?php $__env->startSection('member-content'); ?>
<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;flex-wrap:wrap;gap:16px;">
    <h1 style="margin:0;color:#414141;font-size:24px;font-weight:600;">Adreslerim</h1>
    <a href="<?php echo e(route('member.addresses.create')); ?>" style="display:inline-block;padding:12px 24px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;">+ Yeni Adres Ekle</a>
</div>

<?php if($addresses->count() > 0): ?>
    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(300px, 1fr));gap:20px;">
        <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div style="border:2px solid <?php echo e($address->is_default ? '#7db64f' : '#e5e7eb'); ?>;border-radius:8px;padding:20px;background:#fff;position:relative;">
                <?php if($address->is_default): ?>
                    <div style="position:absolute;top:12px;right:12px;background:#7db64f;color:#fff;padding:4px 12px;border-radius:4px;font-size:11px;font-weight:600;">Varsayılan</div>
                <?php endif; ?>
                
                <div style="margin-bottom:16px;">
                    <div style="font-weight:600;color:#414141;font-size:18px;margin-bottom:8px;"><?php echo e($address->title); ?></div>
                    <div style="color:#666;line-height:1.8;font-size:14px;">
                        <div style="font-weight:600;color:#414141;margin-bottom:4px;"><?php echo e($address->first_name); ?> <?php echo e($address->last_name); ?></div>
                        <div><?php echo e($address->address); ?></div>
                        <div><?php echo e($address->district); ?> / <?php echo e($address->city); ?></div>
                        <?php if($address->postal_code): ?>
                        <div>Posta Kodu: <?php echo e($address->postal_code); ?></div>
                        <?php endif; ?>
                        <div>Tel: <?php echo e($address->phone); ?></div>
                    </div>
                </div>

                <div style="display:flex;gap:8px;flex-wrap:wrap;">
                    <a href="<?php echo e(route('member.addresses.edit', $address)); ?>" style="flex:1;display:inline-block;padding:10px;background:#f0f0f0;color:#414141;text-decoration:none;border-radius:4px;text-align:center;font-size:14px;font-weight:600;">Düzenle</a>
                    <form action="<?php echo e(route('member.addresses.destroy', $address)); ?>" method="POST" style="flex:1;margin:0;" onsubmit="return confirm('Bu adresi silmek istediğinize emin misiniz?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" style="width:100%;padding:10px;background:#e74c3c;color:#fff;border:none;border-radius:4px;font-size:14px;font-weight:600;cursor:pointer;">Sil</button>
                    </form>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php else: ?>
    <div style="text-align:center;padding:60px 20px;color:#666;">
        <div style="font-size:64px;margin-bottom:20px;">📍</div>
        <div style="font-size:20px;margin-bottom:12px;color:#414141;font-weight:600;">Henüz adres eklenmemiş</div>
        <div style="font-size:14px;margin-bottom:24px;">İlk adresinizi ekleyerek başlayın</div>
        <a href="<?php echo e(route('member.addresses.create')); ?>" style="display:inline-block;padding:12px 24px;background:#7db64f;color:#fff;text-decoration:none;border-radius:4px;font-weight:600;">Adres Ekle</a>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('member.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/member/addresses/index.blade.php ENDPATH**/ ?>