
<?php $__env->startSection('content'); ?>
<h1>Slider Yönetimi</h1>
<div class="mt">
    <a class="btn" href="<?php echo e(route('admin.sliders.create')); ?>">Yeni Slider Ekle</a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success mt"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger mt">
        <ul style="margin:0;padding-left:20px;">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<div class="mt" style="background:#fff;border:1px solid #e5e7eb;border-radius:8px;padding:20px;">
    <?php $__empty_1 = true; $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div style="border:1px solid #e5e7eb;border-radius:6px;padding:20px;margin-bottom:20px;background:#f9fafb;">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:15px;">
                <div>
                    <strong style="font-size:18px;color:#1f2937;"><?php echo e($slider->name); ?></strong>
                    <div style="font-size:12px;color:#6b7280;margin-top:4px;">
                        Tip: <?php echo e($slider->type === 'banner' ? 'Banner' : 'Ürün Slider'); ?> | 
                        Sıra: <?php echo e($slider->order); ?> |
                        <?php if($slider->is_active): ?>
                            <span style="color:green;">Aktif</span>
                        <?php else: ?>
                            <span style="color:red;">Pasif</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div style="display:flex;gap:8px;">
                    <a class="btn btn-sm" href="<?php echo e(route('admin.sliders.edit', $slider)); ?>">Düzenle</a>
                    <form action="<?php echo e(route('admin.sliders.destroy', $slider)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Bu slider\'ı silmek istediğinize emin misiniz?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                    </form>
                </div>
            </div>
            
            <div style="margin-top:15px;">
                <strong style="font-size:14px;color:#6b7280;display:block;margin-bottom:10px;">Slider Öğeleri (<?php echo e($slider->items->count()); ?>):</strong>
                <?php if($slider->items->count() > 0): ?>
                    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(200px, 1fr));gap:15px;">
                        <?php $__currentLoopData = $slider->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div style="background:#fff;border:1px solid #e5e7eb;border-radius:6px;padding:12px;">
                                <?php if($slider->type === 'product' && $item->product): ?>
                                    <img src="<?php echo e($item->product->image ? asset($item->product->image) : asset('images/placeholder.png')); ?>" alt="<?php echo e($item->product->name); ?>" style="width:100%;height:120px;object-fit:cover;border-radius:4px;margin-bottom:8px;">
                                    <div style="font-size:12px;font-weight:600;color:#333;margin-bottom:4px;"><?php echo e($item->product->name); ?></div>
                                    <div style="font-size:11px;color:#6b7280;">Sıra: <?php echo e($item->order); ?></div>
                                <?php else: ?>
                                    <?php if($item->image): ?>
                                        <img src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($item->title); ?>" style="width:100%;height:120px;object-fit:cover;border-radius:4px;margin-bottom:8px;">
                                    <?php endif; ?>
                                    <div style="font-size:12px;font-weight:600;color:#333;margin-bottom:4px;"><?php echo e($item->title); ?></div>
                                    <div style="font-size:11px;color:#6b7280;">Sıra: <?php echo e($item->order); ?></div>
                                <?php endif; ?>
                                <form action="<?php echo e(route('admin.sliders.removeItem', $item)); ?>" method="POST" style="margin-top:8px;" onsubmit="return confirm('Bu öğeyi silmek istediğinize emin misiniz?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" style="font-size:11px;padding:4px 8px;">Kaldır</button>
                                </form>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color:#9ca3af;font-size:14px;text-align:center;padding:20px;">Henüz öğe eklenmemiş.</p>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p style="color:#6b7280;text-align:center;padding:40px;">Henüz slider bulunmuyor. İlk slider'ı oluşturun.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/sliders/index.blade.php ENDPATH**/ ?>