<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Giriş | <?php echo e(config('app.name', 'Site')); ?></title>
    <style>
        body { font-family: Arial, sans-serif; background: #0f172a; color:#e5e7eb; margin:0; display:flex; align-items:center; justify-content:center; min-height:100vh; }
        .card { background:#111827; padding:32px; border-radius:12px; box-shadow:0 20px 60px rgba(0,0,0,0.35); width: 360px; }
        h1 { margin-top:0; color:#fff; }
        label { display:block; margin-bottom:6px; color:#cbd5e1; }
        input { width:100%; padding:12px; border-radius:8px; border:1px solid #1f2937; background:#0b1222; color:#e5e7eb; margin-bottom:12px; }
        .btn { width:100%; padding:12px; background:#22c55e; border:none; border-radius:8px; color:#0b1222; font-weight:700; cursor:pointer; }
        .btn:hover { background:#16a34a; }
        .errors { background:#7f1d1d; border:1px solid #fecdd3; color:#fee2e2; padding:12px; border-radius:8px; margin-bottom:12px; }
        .flex { display:flex; align-items:center; gap:8px; }
        small { color:#94a3b8; }
    </style>
</head>
<body>
    <div class="card">
        <h1>Admin Giriş</h1>
        <?php if($errors->any()): ?>
            <div class="errors">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <form method="POST" action="<?php echo e(route('admin.login.post')); ?>">
            <?php echo csrf_field(); ?>
            <label for="email">E-posta</label>
            <input id="email" type="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus>

            <label for="password">Şifre</label>
            <input id="password" type="password" name="password" required>

            <div class="flex" style="margin: 8px 0 16px;">
                <input type="checkbox" id="remember" name="remember" value="1" style="width:auto;">
                <label for="remember" style="margin:0;">Beni hatırla</label>
            </div>

            <button class="btn" type="submit">Giriş yap</button>
            <div style="margin-top:12px;">
                <small>Admin hesabı için `.env` → ADMIN_EMAIL / ADMIN_PASSWORD ve is_admin=true</small>
            </div>
        </form>
    </div>
</body>
</html>


<?php /**PATH C:\xamp\htdocs\laravel-full\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>