@extends('layouts.app')
@section('content')
    <style>
        .search-wrapper { max-width: 1200px; margin: 0 auto; padding: 30px 16px; }
        
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 32px; font-weight: 700; color: #333; margin-bottom: 10px; }
        .page-header .search-info { font-size: 14px; color: #666; }
        .page-header .search-info strong { color: #73ae43; }
        
        .products-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(220px, 1fr)); gap: 25px; }
    </style>

    <div class="search-wrapper">
        <div class="page-header">
            <h1>Arama Sonuçları</h1>
            @if($searchTerm)
                <div class="search-info">
                    "<strong>{{ $searchTerm }}</strong>" için <strong>{{ $products->total() }}</strong> sonuç bulundu.
                </div>
            @else
                <div class="search-info">Lütfen arama terimi girin.</div>
            @endif
        </div>

        @if($products->count() > 0)
            @include('partials.product-grid', ['products' => $products])
            
            <div style="margin-top: 30px; display: flex; justify-content: center;">
                {{ $products->links() }}
            </div>
        @else
            <div style="text-align: center; padding: 60px 20px; background: #f0f9f4; border-radius: 12px;">
                <div style="font-size: 48px; margin-bottom: 20px;">🔍</div>
                <h2 style="font-size: 24px; color: #333; margin-bottom: 10px;">Sonuç bulunamadı</h2>
                <p style="color: #666; margin-bottom: 20px;">Aradığınız kriterlere uygun ürün bulunamadı.</p>
                <a href="{{ route('product.index') }}" style="display: inline-block; background: #73ae43; color: #fff; padding: 12px 24px; border-radius: 6px; text-decoration: none; font-weight: 600;">Tüm Ürünleri Gör</a>
            </div>
        @endif
    </div>
@endsection

