﻿@extends('layouts.app')
@section('content')
@if($page->content)
    {!! $page->content !!}
@else
@verbatim

    

        <div class="ticiTopBlockContent">
            
        </div>
        <div class="clear"></div>

        

        <div id="divIcerik" class="ticiContainer">
            
            
    <div class="categoryOverlay" style="display: none;">
        <div id="loader"></div>
    </div>
    <div id="mainHolder_divBlocks">
        
        <div id="divCenterBlock" class="centerCount iletisimContent">

            <div class="middleTopBlock">
                
            </div>

            
            <div>
                

<script type="text/javascript">

    $(document).ready(function () {
        globalModel.xidActive = true;
        window.mem.init.refreshXId();
    });
    

    let formSubmittedOnce = false;

    function initFieldValidation() {
        const fields = [
            {
                input: 'txtbxAdSoyad',
                error: 'errorAdSoyad',
                validate: (val) => val.trim() !== "",
                emptyMsg: translateIt('Validation_AdSoyadGiriniz'),
                invalidMsg: ""
            },
            {
                input: 'txtbxTelefon',
                error: 'errorTelefon',
                validate: (val) => val.trim() !== "" && /^(\+|00)[1-9][0-9 \-\(\)\.]{7,32}$/.test(val),
                emptyMsg: translateIt('Validation_TelefonGiriniz'),
                invalidMsg: translateIt('Validation_TelefonKontrolEdiniz')
            },
            {
                input: 'txtbxMail',
                error: 'errorMail',
                validate: (val) => val.trim() !== "" && /^\w+([-.+']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/.test(val),
                emptyMsg: translateIt('Validation_MailGiriniz'),
                invalidMsg: translateIt('Validation_MailKontrolEdiniz')
            },
            {
                input: 'txtbxMesaj',
                error: 'errorMesaj',
                validate: (val) => val.trim() !== "",
                emptyMsg: translateIt('Validation_MesajGiriniz'),
                invalidMsg: ""
            },
            {
                input: 'txtGuvenlikKodu',
                error: 'errorCaptcha',
                validate: (val) => val.trim() !== "",
                emptyMsg: translateIt('Validation_GuvenlikKoduGiriniz'),
                invalidMsg: ""
            },
        ];

        fields.forEach(field => {
            const inputEl = document.getElementById(field.input);
            const errorEl = document.getElementById(field.error);

            inputEl.addEventListener('input', () => {
                if (!formSubmittedOnce) return;

                const val = inputEl.value.trim();

                if (val === "") {
                    errorEl.innerText = field.emptyMsg;
                    errorEl.style.visibility = 'visible';
                } else if (!field.validate(val) && field.invalidMsg) {
                    errorEl.innerText = field.invalidMsg;
                    errorEl.style.visibility = 'visible';
                } else {
                    errorEl.innerText = '';
                    errorEl.style.visibility = 'hidden';
                }
            });
        });
    }

    document.addEventListener('DOMContentLoaded', initFieldValidation);

    function FormGonder() {

        formSubmittedOnce = true;

        var isimSoyisim = document.getElementById('txtbxAdSoyad').value.trim();
        var telefon = document.getElementById('txtbxTelefon').value.trim();
        var mail = document.getElementById('txtbxMail').value.trim();
        var mesaj = document.getElementById('txtbxMesaj').value.trim();
        var captcha = document.getElementById('txtGuvenlikKodu').value.trim();

        var validateFields = document.querySelectorAll('.validate');
        validateFields.forEach(function (el) {
            el.innerText = '';
            el.style.visibility = 'hidden';
        });

        document.getElementById('errorAdSoyad').innerText = "";
        document.getElementById('errorTelefon').innerText = "";
        document.getElementById('errorMail').innerText = "";
        document.getElementById('errorMesaj').innerText = "";
        document.getElementById('errorCaptcha').innerText = "";

        var isValid = true;

        if (isimSoyisim === "") {
            var e = document.getElementById('errorAdSoyad');
            e.innerText = translateIt('Validation_AdSoyadGiriniz');
            e.style.visibility = 'visible';
            isValid = false;
        }

        var telRegex = /^(\+|00)[1-9][0-9 \-\(\)\.]{7,32}$/;
        if (telefon === "") {
            var e = document.getElementById('errorTelefon');
            e.innerText = translateIt('Validation_TelefonGiriniz');
            e.style.visibility = 'visible';
            isValid = false;
        } else if (!telRegex.test(telefon)) {
            var e = document.getElementById('errorTelefon');
            e.innerText = translateIt('Validation_TelefonKontrolEdiniz');
            e.style.visibility = 'visible';
            isValid = false;
        }

        var mailRegex = /^\w+([-.+']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
        if (mail === "") {
            var e = document.getElementById('errorMail');
            e.innerText = translateIt('Validation_MailGiriniz');
            e.style.visibility = 'visible';
            isValid = false;
        } else if (!mailRegex.test(mail)) {
            var e = document.getElementById('errorMail');
            e.innerText = translateIt('Validation_MailKontrolEdiniz');
            e.style.visibility = 'visible';
            isValid = false;
        }

        if (mesaj === "") {
            var e = document.getElementById('errorMesaj');
            e.innerText = translateIt('Validation_MesajGiriniz');
            e.style.visibility = 'visible';
            isValid = false;
        }

        if (captcha === "") {
            var e = document.getElementById('errorCaptcha');
            e.innerText = translateIt('Validation_GuvenlikKoduGiriniz');
            e.style.visibility = 'visible';
            isValid = false;
        }

        if (!isValid) return false;

        var data = {
            AdSoyad: isimSoyisim,
            Telefon: telefon,
            Mail: mail,
            Mesaj: mesaj,
            CaptchaCode: captcha
        };
        ticimaxApi.member.sendContactForm(data, function (response) {
            if (response.isError) {
                swal('', response.errorMessage, 'error');
            } else {
                document.getElementById('txtGuvenlikKodu').value = "";
                document.getElementById('txtbxAdSoyad').value = "";
                document.getElementById('txtbxTelefon').value = "";
                document.getElementById('txtbxMail').value = "";
                document.getElementById('txtbxMesaj').value = "";
                window.mem.init.refreshXId();
                swal('', translateIt('Iletisim_BasariliIslemMesaj'), 'success');
            }
        });
    }


</script>


<div class="clear"></div>
<div class="row iletisimLeft">
    <div class="categoryTitle">
        <div class="categoryTitleText">
            İletişim
        </div>
    </div>
    <div class="span iletisimLeftFirmaAdi">
            <div class="Left">Firma Adı</div>
            <div class="Center">:</div>
            <div class="Right">
                Tazemasa Gıda Ürünleri Pazarlama San. Tic. A.S
            </div>
        </div>
    
        <div class="span iletisimLeftTelefon">
            <div class="Left">Telefon </div>
            <div class="Center">:</div>
            <div class="Right">
                <a href="tel:02164610016">
                    02164610016</a>
            </div>
        </div>
    
    <div class="span iletisimLeftFaks">
            <div class="Left">Faks</div>
            <div class="Center">:</div>
            <div class="Right">
                05310844642
            </div>
        </div>
    
        <div class="span iletisimLeftAdres">
            <div class="Left">Adres</div>
            <div class="Center">:</div>
            <div class="Right">
                Esenevler Mah. Talatpaşa Cad. Akyıldız İş Merkezi No:20/8 Ümraniye – İSTANBUL <br>
            </div>
        </div>
    
    
        <div class="span iletisimLeftEposta">
            <div class="Left">E-posta</div>
            <div class="Center">:</div>
            <div class="Right">
                <a href="/cdn-cgi/l/email-protection#e6958394908f95a692879c838b879587c885898b">
                    <span class="__cf_email__" data-cfemail="53203621253a2013273229363e3220327d303c3e">[email&#160;protected]</span></a>
            </div>
        </div>
    
    
        <div class="span iletisimLeftVergiDaire">
            <div class="Left">Vergi Dairesi</div>
            <div class="Center">:</div>
            <div class="Right">
                Ümraniye
            </div>
        </div>
    
    
        <div class="span iletisimLeftVergiNo">
            <div class="Left">Vergi No (Şahış firması iseniz TC no giriniz)</div>
            <div class="Center">:</div>
            <div class="Right">
                8330490139
            </div>
        </div>
    
    
</div>
<div id="mainHolder_Iletisim_divBanka" class="row iletisimRight" style="float: right;">
    <div class="categoryTitle">
        <div class="categoryTitleText">
            Banka Hesap Bilgilerimiz
        </div>
    </div>
    <div class="clear"></div>
    <div class="iletisimbanka">
        <div class="span">
            
                    <div class="line1">
                        <div class="line1">
                            <span style="font-weight: bold;">
                                Banka Adı</span>
                            <span>GARANTİ BANKASI</span>
                        </div>
                        <div class="line2">
                            <span style="font-weight: bold;">
                                Şube</span>
                            <span>Libadiye</span>
                        </div>
                        <div class="line3">
                            <span style="font-weight: bold;">
                                Şube Kodu</span>
                            <span>1017</span>
                        </div>
                        <div class="line4">
                            <span style="font-weight: bold;">
                                Hesap Tipi</span>
                            <span>TL</span>
                        </div>
                    </div>
                    <div class="line2">
                        <div class="line1">
                            <span style="width: 5%; font-weight: bold;">
                                Hesap Adı</span>
                            <span style="width: 5%;">:</span>
                            <span style="width: 90%;">Tazemasa Gıda Ürünleri Pazarlama San.Tic. A.Ş</span>
                        </div>
                        <div class="line2">
                            <span style="width: 5%; font-weight: bold;">
                                Hesap No</span>
                            <span style="width: 5%;">:</span>
                            <span style="width: 90%;">6298865</span>
                        </div>
                    </div>
                    
                    <div class="line3">
                        <div class="line1">
                            <span style="width: 15%; font-weight: bold;">
                                IBAN No</span>
                            <span style="width: 2%;">:</span>
                            <span style="width: 80%;">TR93 0006 2001 0170 0006 2988 65</span>
                        </div>
                    </div>
                
                    <div class="line1">
                        <div class="line1">
                            <span style="font-weight: bold;">
                                Banka Adı</span>
                            <span>Halkbank</span>
                        </div>
                        <div class="line2">
                            <span style="font-weight: bold;">
                                Şube</span>
                            <span>Dudullu</span>
                        </div>
                        <div class="line3">
                            <span style="font-weight: bold;">
                                Şube Kodu</span>
                            <span>1414</span>
                        </div>
                        <div class="line4">
                            <span style="font-weight: bold;">
                                Hesap Tipi</span>
                            <span>TL</span>
                        </div>
                    </div>
                    <div class="line2">
                        <div class="line1">
                            <span style="width: 5%; font-weight: bold;">
                                Hesap Adı</span>
                            <span style="width: 5%;">:</span>
                            <span style="width: 90%;">Tazemasa Gıda ürün.Paz.San.Ve Tic.Aş</span>
                        </div>
                        <div class="line2">
                            <span style="width: 5%; font-weight: bold;">
                                Hesap No</span>
                            <span style="width: 5%;">:</span>
                            <span style="width: 90%;">10101505</span>
                        </div>
                    </div>
                    
                    <div class="line3">
                        <div class="line1">
                            <span style="width: 15%; font-weight: bold;">
                                IBAN No</span>
                            <span style="width: 2%;">:</span>
                            <span style="width: 80%;">TR48 0001 2001 4140 0010 1015 05</span>
                        </div>
                    </div>
                

        </div>
    </div>
</div>
<div class="clear iletisimClear"></div>
<div id="itetisimhtml">
    <style type="text/css">.iletisimForm{display:none!important;} #itetisimhtml{width:95%!important;} .form-control{height:100%!important;}
</style>
<p style="padding-top: 10px;"><strong>Mersis No:&nbsp;</strong> 0833049013900011</p>

<hr /><strong>Depo Adresi:</strong>&nbsp; Namık Kemal mahallesi. Sardunya sokak 5/C&nbsp;Ümraniye İstanbul

<p>&nbsp;</p>
<br />
<iframe height="600" src="https://form.supsis.ai/form/66e14e784b01233c9b47d161/65f7551bced7bbaebba97cbb" width="99%"></iframe>
</div>
<div class="clear iletisimClear"></div>
<div id="mainHolder_Iletisim_divMailGonder" class="iletisimForm">
    <div class="categoryTitle">
        <div class="categoryTitleText">
            İletişim Formu
        </div>
    </div>
    <div class="clear"></div>
    <div class="row rowLeft">
        <div class="span iletisimAdSoyad">
            <div class="Left">Ad Soyad</div>
            <div class="Center">:</div>
            <div class="Right">
                <input type="text" id="txtbxAdSoyad" class="textbox" maxlength="128" placeholder="" />
                <div class="validate" id="errorAdSoyad" style="visibility:hidden;"></div>
            </div>
        </div>
        <div class="span iletisimTelefon">
            <div class="Left">Telefon</div>
            <div class="Center">:</div>
            <div class="Right">
                <input type="text" id="txtbxTelefon" class="ticiTelInput" maxlength="20" placeholder="" />
                <div class="validate" id="errorTelefon" style="visibility:hidden;"></div>
            </div>
        </div>
        <div class="span iletisimEposta">
            <div class="Left">E-posta</div>
            <div class="Center">:</div>
            <div class="Right">
                <input type="text" id="txtbxMail" class="textbox" maxlength="255" placeholder="" />
                <div class="validate" id="errorMail" style="visibility:hidden;"></div>
            </div>
        </div>
    </div>
    <div class="row rowRight">
        <div class="span iletisimMesaj" style="height: 140px;">
            <div class="Left">Mesaj</div>
            <div class="Center">:</div>
            <div class="Right">
                <textarea id="txtbxMesaj" class="textarea" maxlength="255" placeholder=""></textarea>
                <div class="validate" id="errorMesaj" style="visibility:hidden;"></div>
            </div>
        </div>
        <div class="span iletisimCaptcha">
            <div class="Left" style="width: 90px;">Güvenlik Kodu</div>
            <div class="Center">:</div>
            <div class="Right" style="width: 367px;">
                <div class="newUserWrapper xIDDiv divUyeGirisIDDiv">
                    <img id="imgTicimaxCaptcha" class="ticimaxCaptcha" src="#" />
                    <a href="#" style="font-size: 17px; margin-left: 10px;" onclick="window.mem.init.refreshXId()">
                        <i class="fa fa-refresh" aria-hidden="true"></i>
                    </a>
                    <input class="textbox" type="text" id="txtGuvenlikKodu" name="txtGuvenlikKodu" placeholder="Güvenlik Kodu" />
                    <div class="validate" id="errorCaptcha" style="visibility:hidden;"></div>
                </div>
            </div>
        </div>
        <div class="clear"></div>
        <div class="iletisimBtn" style="position: relative; top: 65px; margin-bottom: 60px;">
            <input type="submit" name="ctl00$mainHolder$Iletisim$btnGonder" value="" onclick="FormGonder(); return false;" id="mainHolder_Iletisim_btnGonder" class="button" tici-lang-value="Global_ButtonGonder" />
        </div>
    </div>
</div>
<div class="clear iletisimClear"></div>




                
            </div>
            
            <div class="middleBottomBlock">
                
            </div>

        </div>
        
    </div>
    
    
    
    
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script>
	        if(typeof fbq === 'undefined') {
		        !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
		        n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
		        n.push=n;n.loaded=!0;n.version='2.0';n.agent='plticimax';n.queue=[];t=b.createElement(e);t.async=!0;
		        t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
		        document,'script','//connect.facebook.net/en_US/fbevents.js');

		        fbq('init', '185131392784882', {external_id: 'b585c147e367410839b5885e8e8835bb27c96212cc650917b73e58e0bdfc4cc9', user_agent: 'CyotekWebCopy/1.9 CyotekHTTP/6.4' });
		        fbq('track', 'PageView', {
			        event_source_url: 'https://www.tazemasa.com/Iletisim'
		        }, {eventID: '20251209_vl1jvs3mzfd5j420y345loup_PageView'});
		        fbq('track', 'Contact', {
		        event_source_url: 'https://www.tazemasa.com/Iletisim'
	        }, {eventID: '20251209_vl1jvs3mzfd5j420y345loup_Contact'});
	        }
        </script>

        </div>


        <div class="clear"></div>
        <div class="ticiBottomBlockContent">
            
        </div>
        <div class="clear"></div>
        
        

@endverbatim
@endif
@endsection