@extends('admin.layout')

@section('content')
<h1>İade Talebi Detayı #{{ $return->return_number }}</h1>

@if(session('success'))
    <div style="background:#d4edda;color:#155724;padding:12px;border-radius:4px;margin-bottom:20px;">
        {{ session('success') }}
    </div>
@endif

<div style="display:grid;grid-template-columns:2fr 1fr;gap:20px;margin-bottom:20px;">
    <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
        <h2>Müşteri Bilgileri</h2>
        <p><strong>Ad:</strong> {{ $return->user->name }}</p>
        <p><strong>E-posta:</strong> {{ $return->user->email }}</p>
        <p><strong>Telefon:</strong> {{ $return->user->phone ?? 'Belirtilmemiş' }}</p>
    </div>
    <div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
        <h2>Durum Güncelle</h2>
        <form method="POST" action="{{ route('admin.returns.updateStatus', $return) }}">
            @csrf
            @method('PUT')
            <div style="margin-bottom:12px;">
                <label style="display:block;margin-bottom:4px;">Durum</label>
                <select name="status" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:4px;">
                    <option value="pending" {{ $return->status == 'pending' ? 'selected' : '' }}>Beklemede</option>
                    <option value="approved" {{ $return->status == 'approved' ? 'selected' : '' }}>Onaylandı</option>
                    <option value="rejected" {{ $return->status == 'rejected' ? 'selected' : '' }}>Reddedildi</option>
                    <option value="processing" {{ $return->status == 'processing' ? 'selected' : '' }}>İşleniyor</option>
                    <option value="completed" {{ $return->status == 'completed' ? 'selected' : '' }}>Tamamlandı</option>
                </select>
            </div>
            <div style="margin-bottom:12px;">
                <label style="display:block;margin-bottom:4px;">Yönetici Notu</label>
                <textarea name="admin_notes" rows="3" style="width:100%;padding:8px;border:1px solid #ddd;border-radius:4px;">{{ old('admin_notes', $return->admin_notes) }}</textarea>
            </div>
            <button type="submit" class="btn">Güncelle</button>
        </form>
    </div>
</div>

<div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);margin-bottom:20px;">
    <h2>Talep Bilgileri</h2>
    <p><strong>Talep Tipi:</strong> 
        @if($return->type == 'return') İade
        @elseif($return->type == 'exchange') Değişim
        @elseif($return->type == 'cancellation') İptal
        @endif
    </p>
    <p><strong>Sipariş No:</strong> {{ $return->order->order_number }}</p>
    <p><strong>Talep Tarihi:</strong> {{ $return->created_at->format('d.m.Y H:i') }}</p>
    <div style="margin-top:16px;">
        <strong>Talep Nedeni:</strong>
        <div style="background:#f9f9f9;padding:12px;border-radius:4px;margin-top:8px;">{{ $return->reason }}</div>
    </div>
</div>

@if($return->orderItem)
<div style="background:#fff;padding:20px;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
    <h2>İlgili Ürün</h2>
    <p><strong>Ürün:</strong> {{ $return->orderItem->product_name }}</p>
    <p><strong>Adet:</strong> {{ $return->orderItem->quantity }}</p>
    <p><strong>Tutar:</strong> {{ number_format($return->orderItem->total, 2) }} ₺</p>
</div>
@endif

<div style="margin-top:20px;">
    <a href="{{ route('admin.returns.index') }}" class="btn secondary">← Geri Dön</a>
</div>
@endsection

