@extends('admin.layout')
@section('content')
<h1>Sayfa Düzenle</h1>

<form method="POST" action="{{ route('admin.pages.update', $page) }}" class="mt">
    @csrf
    @method('PUT')
    
    <div class="form-group">
        <label>Slug (URL)</label>
        <input type="text" name="slug" value="{{ old('slug', $page->slug) }}" required class="form-control" placeholder="ornek-sayfa">
        <small>URL'de görünecek kısım (örn: ornek-sayfa)</small>
    </div>

    <div class="form-group">
        <label>Başlık</label>
        <input type="text" name="title" value="{{ old('title', $page->title) }}" required class="form-control">
    </div>

    <div class="form-group">
        <label>İçerik</label>
        <textarea name="content" rows="10" class="form-control">{{ old('content', $page->content) }}</textarea>
    </div>

    <hr style="margin:30px 0;border:none;border-top:1px solid #e5e7eb;">

    <h2 style="margin-bottom:20px;">SEO Ayarları</h2>

    <div class="form-group">
        <label>Meta Başlık (Title)</label>
        <input type="text" name="meta_title" value="{{ old('meta_title', $page->meta_title) }}" class="form-control" maxlength="60">
        <small>Maksimum 60 karakter önerilir. Boş bırakılırsa sayfa başlığı kullanılır.</small>
    </div>

    <div class="form-group">
        <label>Meta Açıklama (Description)</label>
        <textarea name="meta_description" rows="3" class="form-control" maxlength="160">{{ old('meta_description', $page->meta_description) }}</textarea>
        <small>Maksimum 160 karakter önerilir</small>
    </div>

    <div class="form-group">
        <label>Meta Anahtar Kelimeleri</label>
        <input type="text" name="meta_keywords" value="{{ old('meta_keywords', $page->meta_keywords) }}" class="form-control" placeholder="kelime1, kelime2, kelime3">
        <small>Virgülle ayrılmış anahtar kelimeler</small>
    </div>

    <div class="form-group">
        <label>
            <input type="checkbox" name="is_active" value="1" {{ old('is_active', $page->is_active) ? 'checked' : '' }}>
            Aktif
        </label>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Güncelle</button>
        <a class="btn secondary" href="{{ route('admin.pages.index') }}">İptal</a>
    </div>
</form>
@endsection

