@extends('admin.layout')
@section('content')
<h1>Kampanya Düzenle: {{ $campaign->title }}</h1>

<form method="POST" action="{{ route('admin.campaigns.update', $campaign) }}" enctype="multipart/form-data" class="mt">
    @csrf
    @method('PUT')
    
    <div class="form-group">
        <label>Kampanya Başlığı *</label>
        <input type="text" name="title" value="{{ old('title', $campaign->title) }}" required class="form-control" placeholder="Örn: %50'ye Varan İndirimler">
        <small>Kampanya başlığı otomatik olarak slug'a dönüştürülecektir</small>
    </div>

    <div class="form-group">
        <label>Kısa Açıklama</label>
        <textarea name="description" rows="3" class="form-control" placeholder="Kampanya hakkında kısa açıklama...">{{ old('description', $campaign->description) }}</textarea>
    </div>

    <div class="form-group">
        <label>Detaylı İçerik</label>
        <textarea name="content" rows="6" class="form-control" placeholder="Kampanya detayları...">{{ old('content', $campaign->content) }}</textarea>
        <small>HTML kullanabilirsiniz</small>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Kampanya Görseli</label>
            <input type="file" name="image" accept="image/*" class="form-control">
            @if($campaign->image)
                <div style="margin-top:10px;">
                    <img src="{{ asset($campaign->image) }}" alt="Mevcut görsel" style="max-width:200px;border:1px solid #e5e7eb;border-radius:4px;padding:5px;">
                    <p style="margin:5px 0 0 0;font-size:12px;color:#666;">Mevcut görsel</p>
                </div>
            @endif
            <small>Yeni görsel yüklerseniz mevcut görsel değiştirilecektir</small>
        </div>

        <div class="form-group">
            <label>Banner Görseli</label>
            <input type="file" name="banner_image" accept="image/*" class="form-control">
            @if($campaign->banner_image)
                <div style="margin-top:10px;">
                    <img src="{{ asset($campaign->banner_image) }}" alt="Mevcut banner" style="max-width:200px;border:1px solid #e5e7eb;border-radius:4px;padding:5px;">
                    <p style="margin:5px 0 0 0;font-size:12px;color:#666;">Mevcut banner</p>
                </div>
            @endif
            <small>Yeni banner yüklerseniz mevcut banner değiştirilecektir</small>
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>İndirim Yüzdesi (%)</label>
            <input type="number" name="discount_percentage" value="{{ old('discount_percentage', $campaign->discount_percentage) }}" class="form-control" min="0" max="100" step="0.01" placeholder="Örn: 50">
            <small>Yüzde olarak indirim (örn: 50 = %50)</small>
        </div>

        <div class="form-group">
            <label>İndirim Tutarı (₺)</label>
            <input type="number" name="discount_amount" value="{{ old('discount_amount', $campaign->discount_amount) }}" class="form-control" min="0" step="0.01" placeholder="Örn: 100">
            <small>Tutar olarak indirim (örn: 100 = ₺100)</small>
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Başlangıç Tarihi</label>
            <input type="date" name="start_date" value="{{ old('start_date', $campaign->start_date ? $campaign->start_date->format('Y-m-d') : '') }}" class="form-control">
            <small>Boş bırakılırsa hemen başlar</small>
        </div>

        <div class="form-group">
            <label>Bitiş Tarihi</label>
            <input type="date" name="end_date" value="{{ old('end_date', $campaign->end_date ? $campaign->end_date->format('Y-m-d') : '') }}" class="form-control">
            <small>Boş bırakılırsa süresiz olur</small>
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Buton Metni</label>
            <input type="text" name="button_text" value="{{ old('button_text', $campaign->button_text) }}" class="form-control" placeholder="Örn: Fırsatı İnceleyin">
        </div>

        <div class="form-group">
            <label>Buton Linki</label>
            <input type="text" name="button_link" value="{{ old('button_link', $campaign->button_link) }}" class="form-control" placeholder="Örn: /kampanyalar veya https://...">
        </div>
    </div>

    <div class="form-row" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;">
        <div class="form-group">
            <label>Sıra</label>
            <input type="number" name="order" value="{{ old('order', $campaign->order) }}" class="form-control" min="0">
            <small>Kampanyaların sıralaması (küçükten büyüğe)</small>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $campaign->is_active) ? 'checked' : '' }}>
                Aktif
            </label>
            <small style="display:block;margin-top:5px;">Kampanya aktif olarak görünsün mü?</small>
        </div>
    </div>

    <div class="flex mt">
        <button type="submit" class="btn">Güncelle</button>
        <a class="btn secondary" href="{{ route('admin.campaigns.index') }}">İptal</a>
    </div>
</form>
@endsection

