<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;

class PagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            [
                'slug' => 'Iletisim',
                'title' => 'İletişim',
                'content' => '<div class="ticiContainer">
    <div id="mainHolder_divBlocks">
        <div id="divCenterBlock" class="centerCount iletisimContent">
            <div class="row iletisimLeft">
                <div class="categoryTitle">
                    <div class="categoryTitleText">İletişim</div>
                </div>
                <div class="span iletisimLeftFirmaAdi">
                    <div class="Left">Firma Adı</div>
                    <div class="Center">:</div>
                    <div class="Right">Tazemasa Gıda Ürünleri Pazarlama San. Tic. A.S</div>
                </div>
                <div class="span iletisimLeftTelefon">
                    <div class="Left">Telefon</div>
                    <div class="Center">:</div>
                    <div class="Right"><a href="tel:02164610016">02164610016</a></div>
                </div>
                <div class="span iletisimLeftFaks">
                    <div class="Left">Faks</div>
                    <div class="Center">:</div>
                    <div class="Right">05310844642</div>
                </div>
                <div class="span iletisimLeftAdres">
                    <div class="Left">Adres</div>
                    <div class="Center">:</div>
                    <div class="Right">Esenevler Mah. Talatpaşa Cad. Akyıldız İş Merkezi No:20/8 Ümraniye – İSTANBUL</div>
                </div>
                <div class="span iletisimLeftEposta">
                    <div class="Left">E-posta</div>
                    <div class="Center">:</div>
                    <div class="Right"><a href="mailto:[email&#160;protected]">[email&#160;protected]</a></div>
                </div>
                <div class="span iletisimLeftVergiDaire">
                    <div class="Left">Vergi Dairesi</div>
                    <div class="Center">:</div>
                    <div class="Right">Ümraniye</div>
                </div>
                <div class="span iletisimLeftVergiNo">
                    <div class="Left">Vergi No</div>
                    <div class="Center">:</div>
                    <div class="Right">8330490139</div>
                </div>
            </div>
            <div id="mainHolder_Iletisim_divBanka" class="row iletisimRight" style="float: right;">
                <div class="categoryTitle">
                    <div class="categoryTitleText">Banka Hesap Bilgilerimiz</div>
                </div>
                <div class="iletisimbanka">
                    <div class="span">
                        <div class="line1">
                            <div class="line1">
                                <span style="font-weight: bold;">Banka Adı</span>
                                <span>GARANTİ BANKASI</span>
                            </div>
                            <div class="line2">
                                <span style="font-weight: bold;">Şube</span>
                                <span>Libadiye</span>
                            </div>
                            <div class="line3">
                                <span style="font-weight: bold;">Şube Kodu</span>
                                <span>1017</span>
                            </div>
                            <div class="line4">
                                <span style="font-weight: bold;">Hesap Tipi</span>
                                <span>TL</span>
                            </div>
                        </div>
                        <div class="line2">
                            <div class="line1">
                                <span style="width: 5%; font-weight: bold;">Hesap Adı</span>
                                <span style="width: 5%;">:</span>
                                <span style="width: 90%;">Tazemasa Gıda Ürünleri Pazarlama San.Tic. A.Ş</span>
                            </div>
                            <div class="line2">
                                <span style="width: 5%; font-weight: bold;">Hesap No</span>
                                <span style="width: 5%;">:</span>
                                <span style="width: 90%;">6298865</span>
                            </div>
                        </div>
                        <div class="line3">
                            <div class="line1">
                                <span style="width: 15%; font-weight: bold;">IBAN No</span>
                                <span style="width: 2%;">:</span>
                                <span style="width: 80%;">TR93 0006 2001 0170 0006 2988 65</span>
                            </div>
                        </div>
                        <div class="line1">
                            <div class="line1">
                                <span style="font-weight: bold;">Banka Adı</span>
                                <span>Halkbank</span>
                            </div>
                            <div class="line2">
                                <span style="font-weight: bold;">Şube</span>
                                <span>Dudullu</span>
                            </div>
                            <div class="line3">
                                <span style="font-weight: bold;">Şube Kodu</span>
                                <span>1414</span>
                            </div>
                            <div class="line4">
                                <span style="font-weight: bold;">Hesap Tipi</span>
                                <span>TL</span>
                            </div>
                        </div>
                        <div class="line2">
                            <div class="line1">
                                <span style="width: 5%; font-weight: bold;">Hesap Adı</span>
                                <span style="width: 5%;">:</span>
                                <span style="width: 90%;">Tazemasa Gıda ürün.Paz.San.Ve Tic.Aş</span>
                            </div>
                            <div class="line2">
                                <span style="width: 5%; font-weight: bold;">Hesap No</span>
                                <span style="width: 5%;">:</span>
                                <span style="width: 90%;">10101505</span>
                            </div>
                        </div>
                        <div class="line3">
                            <div class="line1">
                                <span style="width: 15%; font-weight: bold;">IBAN No</span>
                                <span style="width: 2%;">:</span>
                                <span style="width: 80%;">TR48 0001 2001 4140 0010 1015 05</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear iletisimClear"></div>
            <div id="itetisimhtml">
                <p style="padding-top: 10px;"><strong>Mersis No:</strong> 0833049013900011</p>
                <hr />
                <strong>Depo Adresi:</strong> Namık Kemal mahallesi. Sardunya sokak 5/C Ümraniye İstanbul
            </div>
        </div>
    </div>
</div>',
                'meta_title' => 'İletişim | Tazemasa',
                'meta_description' => 'Tazemasa iletişim bilgileri, adres, telefon, e-posta ve banka hesap bilgileri. Bize ulaşın, sorularınızı yanıtlayalım.',
                'meta_keywords' => 'tazemasa iletişim, tazemasa adres, tazemasa telefon, tazemasa banka hesap bilgileri',
                'is_active' => true,
            ],
            [
                'slug' => 'blog',
                'title' => 'Blog',
                'content' => '<div class="ticiContainer">
    <div class="blogCenter col-md-9 col-lg-9 col-xs-12 col-sm-12">
        <h1 class="blog-h1">Blog</h1>
        <p>Organik ürünler, sağlıklı yaşam, tarifler ve daha fazlası için blog yazılarımızı takip edin.</p>
    </div>
</div>',
                'meta_title' => 'Blog | Tazemasa',
                'meta_description' => 'Tazemasa blog sayfası. Organik ürünler, sağlıklı yaşam, tarifler ve daha fazlası için blog yazılarımızı okuyun.',
                'meta_keywords' => 'tazemasa blog, organik ürünler blog, sağlıklı yaşam, tarifler',
                'is_active' => true,
            ],
            [
                'slug' => 'sik-sorulan-sorular-8',
                'title' => 'Sık Sorulan Sorular',
                'content' => '<div class="ticiContainer" style="padding:40px 20px;">
    <h1 style="text-align:center;margin-bottom:30px;color:#73ae43;">Sıkça Sorulan Sorular</h1>
    <div style="max-width:800px;margin:0 auto;">
        <div style="margin-bottom:20px;padding:20px;background:#f9f9f9;border-radius:8px;">
            <h3 style="color:#333;margin-bottom:10px;">Siparişim ne zaman teslim edilir?</h3>
            <p style="color:#666;line-height:1.6;">Siparişleriniz genellikle 1-2 iş günü içinde teslim edilir.</p>
        </div>
        <div style="margin-bottom:20px;padding:20px;background:#f9f9f9;border-radius:8px;">
            <h3 style="color:#333;margin-bottom:10px;">Ücretsiz kargo var mı?</h3>
            <p style="color:#666;line-height:1.6;">200 TL ve üzeri siparişlerde ücretsiz kargo uygulanmaktadır.</p>
        </div>
        <div style="margin-bottom:20px;padding:20px;background:#f9f9f9;border-radius:8px;">
            <h3 style="color:#333;margin-bottom:10px;">İade ve değişim nasıl yapılır?</h3>
            <p style="color:#666;line-height:1.6;">Ürünlerinizi teslimat tarihinden itibaren 14 gün içinde iade edebilirsiniz.</p>
        </div>
    </div>
</div>',
                'meta_title' => 'Sık Sorulan Sorular | Tazemasa',
                'meta_description' => 'Tazemasa sık sorulan sorular sayfası. Sipariş, teslimat, iade ve diğer konularda merak ettiklerinizin cevapları.',
                'meta_keywords' => 'tazemasa sık sorulan sorular, sipariş soruları, teslimat soruları, iade soruları',
                'is_active' => true,
            ],
            [
                'slug' => 'neden-tazemasa-26',
                'title' => 'Neden Tazemasa',
                'content' => '<div class="ticiContainer" style="padding:40px 20px;">
    <h1 style="text-align:center;margin-bottom:30px;color:#73ae43;">Neden Tazemasa?</h1>
    <div style="max-width:800px;margin:0 auto;line-height:1.8;color:#666;">
        <p style="margin-bottom:20px;">Tazemasa olarak, doğadan geldiği gibi saf, zehirsiz, katkısız ve hayata saygılı ürünlerin adresi olmaya devam ediyoruz.</p>
        <p style="margin-bottom:20px;">Organik sertifikalı ürünlerimiz ve taze meyve-sebzelerimizle sağlıklı yaşamı destekliyoruz.</p>
    </div>
</div>',
                'meta_title' => 'Neden Tazemasa? | Tazemasa',
                'meta_description' => 'Tazemasa neden tercih edilmeli? Organik sertifikalı ürünler, taze meyve-sebzeler ve sağlıklı yaşam için Tazemasa.',
                'meta_keywords' => 'neden tazemasa, tazemasa avantajları, organik ürünler, taze meyve sebze',
                'is_active' => true,
            ],
            [
                'slug' => 'gizlilik-ve-guvenlik-9',
                'title' => 'Gizlilik ve Güvenlik',
                'content' => '<div class="ticiContainer" style="padding:40px 20px;">
    <h1 style="text-align:center;margin-bottom:30px;color:#73ae43;">Gizlilik & Güvenlik</h1>
    <div style="max-width:800px;margin:0 auto;line-height:1.8;color:#666;">
        <p style="margin-bottom:20px;">Kişisel verilerinizin güvenliği bizim için önemlidir.</p>
        <p style="margin-bottom:20px;">Tüm bilgileriniz SSL sertifikası ile korunmaktadır.</p>
    </div>
</div>',
                'meta_title' => 'Gizlilik ve Güvenlik | Tazemasa',
                'meta_description' => 'Tazemasa gizlilik ve güvenlik politikası. Kişisel verilerinizin korunması ve SSL güvenliği hakkında bilgiler.',
                'meta_keywords' => 'tazemasa gizlilik, tazemasa güvenlik, kişisel veri koruma, SSL güvenlik',
                'is_active' => true,
            ],
            [
                'slug' => 'kullanim-kosullari-6',
                'title' => 'Kullanım Koşulları',
                'content' => '<div class="ticiContainer" style="padding:40px 20px;">
    <h1 style="text-align:center;margin-bottom:30px;color:#73ae43;">Kullanım Şartları</h1>
    <div style="max-width:800px;margin:0 auto;line-height:1.8;color:#666;">
        <p style="margin-bottom:20px;">Sitemizi kullanarak kullanım şartlarımızı kabul etmiş sayılırsınız.</p>
    </div>
</div>',
                'meta_title' => 'Kullanım Koşulları | Tazemasa',
                'meta_description' => 'Tazemasa kullanım koşulları. Sitemizi kullanırken uymanız gereken kurallar ve şartlar.',
                'meta_keywords' => 'tazemasa kullanım koşulları, site kullanım şartları, kullanıcı sözleşmesi',
                'is_active' => true,
            ],
            [
                'slug' => 'para-puan-nedir',
                'title' => 'Para Puan Nedir?',
                'content' => '<div class="tm-page-container" style="max-width:900px;margin:50px auto;padding:30px;">
    <h1 style="margin:0 0 30px;color:#414141;font-size:28px;font-weight:600;text-align:center;">Para Puan Nedir?</h1>
    <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:40px;line-height:1.8;color:#414141;font-size:15px;">
        <p style="margin:0 0 20px;font-size:18px;color:#7db64f;font-weight:600;">
            Tazemasa\'nın müşterileri için oluşturduğu fayda programlarından birisidir.
        </p>
        <p style="margin:0;font-size:16px;">
            <strong>1 Parapuan = 1 TL\'dir.</strong>
        </p>
    </div>
</div>',
                'meta_title' => 'Para Puan Nedir? | Tazemasa',
                'meta_description' => 'Tazemasa Para Puan sistemi hakkında bilgiler. 1 Parapuan = 1 TL. Alışverişlerinizde para puan kazanın ve kullanın.',
                'meta_keywords' => 'para puan, parapuan, tazemasa para puan, puan sistemi, sadakat programı',
                'is_active' => true,
            ],
            [
                'slug' => 'organik-sertifikalar',
                'title' => 'Organik Sertifikalar',
                'content' => '<div class="tm-page-container" style="max-width:900px;margin:50px auto;padding:30px;">
    <h1 style="margin:0 0 30px;color:#414141;font-size:28px;font-weight:600;text-align:center;">Organik Sertifikalar</h1>
    <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:40px;line-height:1.8;color:#414141;font-size:15px;">
        <p style="margin:0 0 20px;">
            Tazemasa olarak, müşterilerimize en kaliteli ve güvenilir organik ürünleri sunmak için çalışıyoruz. Tüm organik ürünlerimiz, uluslararası standartlara uygun olarak sertifikalandırılmıştır.
        </p>
        <p style="margin:0 0 20px;">
            Organik sertifikalarımız, ürünlerimizin doğal ve sağlıklı olduğunu garanti eder. Bu sertifikalar sayesinde, satın aldığınız organik ürünlerin gerçekten organik olduğundan emin olabilirsiniz.
        </p>
        <p style="margin:0;">
            Daha fazla bilgi için bizimle iletişime geçebilirsiniz.
        </p>
    </div>
</div>',
                'meta_title' => 'Organik Sertifikalar | Tazemasa',
                'meta_description' => 'Tazemasa organik sertifikaları. Uluslararası standartlara uygun organik ürün sertifikalarımız hakkında bilgiler.',
                'meta_keywords' => 'organik sertifika, organik ürün sertifikası, tazemasa organik, organik belge',
                'is_active' => true,
            ],
            [
                'slug' => 'siparisin-nerede',
                'title' => 'Siparişin Nerede',
                'content' => '<div class="tm-page-container" style="max-width:900px;margin:50px auto;padding:30px;">
    <h1 style="margin:0 0 30px;color:#414141;font-size:28px;font-weight:600;text-align:center;">Siparişin Nerede?</h1>
    <p style="text-align:center;color:#666;margin-bottom:30px;">Sipariş takip kodunuzu girerek siparişinizin durumunu öğrenebilirsiniz.</p>
</div>',
                'meta_title' => 'Siparişin Nerede? | Tazemasa',
                'meta_description' => 'Tazemasa sipariş takip sayfası. Sipariş takip kodunuz ile siparişinizin durumunu öğrenin.',
                'meta_keywords' => 'sipariş takip, kargo takip, sipariş sorgulama, tazemasa sipariş takip',
                'is_active' => true,
            ],
            [
                'slug' => 'sevkiyat',
                'title' => 'Sevkiyat',
                'content' => '<div class="tm-page-container" style="max-width:900px;margin:50px auto;padding:30px;">
    <h1 style="margin:0 0 30px;color:#414141;font-size:28px;font-weight:600;text-align:center;">Sevkiyat Bilgileri</h1>
    <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:40px;line-height:1.8;color:#414141;font-size:15px;">
        <h2 style="margin:0 0 20px;color:#414141;font-size:20px;font-weight:600;">Teslimat Süreleri</h2>
        <p style="margin:0 0 20px;">
            Siparişleriniz, onaylandıktan sonra en kısa sürede hazırlanır ve size ulaştırılır. Standart teslimat süremiz 1-3 iş günüdür.
        </p>
        <h2 style="margin:30px 0 20px;color:#414141;font-size:20px;font-weight:600;">Kargo Bilgileri</h2>
        <p style="margin:0 0 20px;">
            Siparişleriniz güvenli paketleme ile kargoya verilir. Kargo takip kodunuz ile siparişinizin durumunu "Siparişin Nerede?" sayfasından takip edebilirsiniz.
        </p>
        <h2 style="margin:30px 0 20px;color:#414141;font-size:20px;font-weight:600;">Ücretsiz Kargo</h2>
        <p style="margin:0;">
            Belirli tutarın üzerindeki siparişlerde ücretsiz kargo hizmeti sunuyoruz. Detaylı bilgi için kampanyalarımızı takip edin.
        </p>
    </div>
</div>',
                'meta_title' => 'Sevkiyat Bilgileri | Tazemasa',
                'meta_description' => 'Tazemasa sevkiyat ve teslimat bilgileri. Teslimat süreleri, kargo bilgileri ve ücretsiz kargo hakkında bilgiler.',
                'meta_keywords' => 'sevkiyat, teslimat, kargo, ücretsiz kargo, tazemasa sevkiyat',
                'is_active' => true,
            ],
            [
                'slug' => 'yardim',
                'title' => 'Yardım',
                'content' => '<div class="tm-page-container" style="max-width:900px;margin:50px auto;padding:30px;">
    <h1 style="margin:0 0 30px;color:#414141;font-size:28px;font-weight:600;text-align:center;">Sıkça Sorulan Sorular</h1>
    <div style="background:#fff;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);padding:40px;">
        <div style="display:flex;flex-direction:column;gap:20px;">
            <div style="border-bottom:1px solid #e5e7eb;padding-bottom:20px;">
                <h3 style="margin:0 0 12px;color:#7db64f;font-size:18px;font-weight:600;">Siparişimi nasıl takip edebilirim?</h3>
                <p style="margin:0;color:#666;line-height:1.8;">
                    Siparişinizin takip kodunu "Siparişin Nerede?" sayfasından sorgulayarak sipariş durumunuzu öğrenebilirsiniz. Ayrıca üye panelinizden de siparişlerinizi takip edebilirsiniz.
                </p>
            </div>
            <div style="border-bottom:1px solid #e5e7eb;padding-bottom:20px;">
                <h3 style="margin:0 0 12px;color:#7db64f;font-size:18px;font-weight:600;">Para Puan nedir ve nasıl kazanırım?</h3>
                <p style="margin:0;color:#666;line-height:1.8;">
                    Para Puan, Tazemasa\'nın müşterileri için oluşturduğu fayda programlarından birisidir. 1 Parapuan = 1 TL\'dir. Alışverişlerinizde para puan kazanabilir ve sonraki alışverişlerinizde kullanabilirsiniz.
                </p>
            </div>
            <div style="border-bottom:1px solid #e5e7eb;padding-bottom:20px;">
                <h3 style="margin:0 0 12px;color:#7db64f;font-size:18px;font-weight:600;">Siparişimi iptal edebilir miyim?</h3>
                <p style="margin:0;color:#666;line-height:1.8;">
                    Siparişiniz henüz hazırlanmaya başlamadıysa iptal edebilirsiniz. İptal işlemi için üye panelinizden "İade/İptal" bölümünü kullanabilirsiniz.
                </p>
            </div>
            <div style="border-bottom:1px solid #e5e7eb;padding-bottom:20px;">
                <h3 style="margin:0 0 12px;color:#7db64f;font-size:18px;font-weight:600;">Ürün iade edebilir miyim?</h3>
                <p style="margin:0;color:#666;line-height:1.8;">
                    Evet, teslim edilen siparişleriniz için "İade/İptal" bölümünden iade talebi oluşturabilirsiniz. İade koşulları için lütfen iade politikamızı inceleyin.
                </p>
            </div>
            <div style="border-bottom:1px solid #e5e7eb;padding-bottom:20px;">
                <h3 style="margin:0 0 12px;color:#7db64f;font-size:18px;font-weight:600;">Kargo ücreti ne kadar?</h3>
                <p style="margin:0;color:#666;line-height:1.8;">
                    Belirli tutarın üzerindeki siparişlerde ücretsiz kargo hizmeti sunuyoruz. Detaylı bilgi için kampanyalarımızı takip edin.
                </p>
            </div>
            <div>
                <h3 style="margin:0 0 12px;color:#7db64f;font-size:18px;font-weight:600;">Başka bir sorum var, nereye başvurabilirim?</h3>
                <p style="margin:0;color:#666;line-height:1.8;">
                    Sorularınız için iletişim sayfamızdan bize ulaşabilirsiniz.
                </p>
            </div>
        </div>
    </div>
</div>',
                'meta_title' => 'Yardım | Tazemasa',
                'meta_description' => 'Tazemasa yardım sayfası. Sıkça sorulan sorular, sipariş takibi, para puan, iade ve diğer konularda yardım.',
                'meta_keywords' => 'tazemasa yardım, sipariş takibi, para puan, iade, müşteri hizmetleri',
                'is_active' => true,
            ],
        ];

        foreach ($pages as $pageData) {
            Page::updateOrCreate(
                ['slug' => $pageData['slug']],
                $pageData
            );
        }
    }
}
