<?php

namespace Database\Seeders;

use App\Models\Menu;
use App\Models\MenuItem;
use Illuminate\Database\Seeder;

class MenuSeeder extends Seeder
{
    public function run(): void
    {
        // Header
        $header = Menu::firstOrCreate(
            ['slug' => 'header'],
            ['name' => 'Header', 'location' => 'primary', 'is_active' => true]
        );

        $headerItems = [
            ['title' => 'Ana Sayfa', 'route_name' => 'home', 'order' => 1],
            ['title' => 'Blog', 'route_name' => 'blog', 'order' => 2],
            ['title' => 'İletişim', 'route_name' => 'contact', 'order' => 3],
        ];

        foreach ($headerItems as $item) {
            MenuItem::updateOrCreate(
                ['menu_id' => $header->id, 'title' => $item['title']],
                $item + ['menu_id' => $header->id, 'is_active' => true]
            );
        }

        // Footer
        $footer = Menu::firstOrCreate(
            ['slug' => 'footer'],
            ['name' => 'Footer', 'location' => 'footer', 'is_active' => true]
        );

        $footerItems = [
            ['title' => 'Hakkında', 'route_name' => 'about', 'order' => 1],
            ['title' => 'Gizlilik', 'route_name' => 'privacy', 'order' => 2],
            ['title' => 'Kullanım Koşulları', 'route_name' => 'terms', 'order' => 3],
            ['title' => 'Sık Sorulan Sorular', 'route_name' => 'faq', 'order' => 4],
        ];

        foreach ($footerItems as $item) {
            MenuItem::updateOrCreate(
                ['menu_id' => $footer->id, 'title' => $item['title']],
                $item + ['menu_id' => $footer->id, 'is_active' => true]
            );
        }
    }
}


